﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


namespace Tmatrix
{
    public partial class ABCDComponentEntry : Form
    {
        public Tile tile;
        private Rectangle rect;

        private static int schematicWidth = 240;
        private static int schematicHeight = 160;

        public ABCDComponentEntry(Tile newtile)
        {
            InitializeComponent();
            tile = newtile;                     // tile selected for entry
            rect = new Rectangle(260, 250,      // where tile graphic is drawn on the form
                schematicWidth, schematicHeight);
        }

        /// <summary>
        /// The state of the component-type radio buttons has changed.
        /// Alter what's displayed on the form for user input.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ComponentTypeChanged(object sender, EventArgs e)
        {
            Refresh();
        }

        /// <summary>
        /// Paint the input form based on user changes in the network parameters 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void paintForm(object sender, PaintEventArgs e)
        {
            if (shuntYbutton.Checked)
            {
                e.Graphics.DrawImage(tilebitmaps.Shunt_Y, rect);
                RLCgroupBox.Enabled = true;
                ResistanceLabel.Text = "Resistance, Ohms";
                InductanceLabel.Text = "Inductance, uHy";
                CapacitanceLabel.Text = "Capacitance, pF";
                InductancetextBox.Enabled = true;
                CapacitancetextBox.Enabled = true;
            }

            if (seriesTLbutton.Checked)
            {
                e.Graphics.DrawImage(tilebitmaps.Series_TL, rect);
                tile.m_type = NetworkType.SeriesTL;
                RLCgroupBox.Enabled = false;
                ResistanceLabel.Text = "Cable impedance, Ohms";
                InductanceLabel.Text = "Cable Beta factor";
                CapacitanceLabel.Text = "Cable Length, meters";
                InductancetextBox.Enabled = true;
                CapacitancetextBox.Enabled = true;
            }

            if (seriesZbutton.Checked)
            {
                e.Graphics.DrawImage(tilebitmaps.Series_Z, rect);
                RLCgroupBox.Enabled = true;
                ResistanceLabel.Text = "Resistance, Ohms";
                InductanceLabel.Text = "Inductance, uHy";
                CapacitanceLabel.Text = "Capacitance, pF";
                InductancetextBox.Enabled = true;
                CapacitancetextBox.Enabled = true;
            }

            if (transformerbutton.Checked)
            {
                e.Graphics.DrawImage(tilebitmaps.Transformer, rect);
                RLCgroupBox.Enabled = false;
                ResistanceLabel.Text = "Turns ratio (left:right)";
                InductanceLabel.Text = "";
                CapacitanceLabel.Text = "";
                InductancetextBox.Enabled = false;
                CapacitancetextBox.Enabled = false;
            }

            if (pibutton.Checked)
            {
                e.Graphics.DrawImage(tilebitmaps.Pi_Net, rect);
                RLCgroupBox.Enabled = false;
                ResistanceLabel.Text = "TODO";
                InductanceLabel.Text = "TODO";
                CapacitanceLabel.Text = "TODO";
            }

            if (teebutton.Checked)
            {
                e.Graphics.DrawImage(tilebitmaps.Tee_Net, rect);
                RLCgroupBox.Enabled = false;
                ResistanceLabel.Text = "TODO";
                InductanceLabel.Text = "TODO";
                CapacitanceLabel.Text = "TODO";
            }
        }

        /// <summary>
        /// Validate numeric values then update the component type and values
        /// of the tile. 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ClickOK(object sender, EventArgs e)
        {
            double line1, line2, line3;

            try    // all formats return at least one value
            {
                line1 = Convert.ToDouble(ResistancetextBox.Text);
            }
            catch (FormatException f)
            {
                MessageBox.Show("Invalid numeric format", f.Message,
                    MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            tile.m_elecParam1 = line1;

            if (shuntYbutton.Checked || seriesZbutton.Checked ||
                seriesTLbutton.Checked)
            {
                try   // other formats return the other two values as well
                {
                    line2 = Convert.ToDouble(InductancetextBox.Text);
                    line3 = Convert.ToDouble(CapacitancetextBox.Text);
                }
                catch (FormatException f)
                {
                    MessageBox.Show("Invalid numeric format", f.Message,
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
                tile.m_elecParam2 = line2;
                tile.m_elecParam3 = line3;
            }

            if (shuntYbutton.Checked)
            {
                if (RLCseriesButton.Checked)
                    tile.m_type = NetworkType.ShuntYserRLC;
                if (RLCparallelButton.Checked)
                    tile.m_type = NetworkType.ShuntYparRLC;
            }
            if (seriesZbutton.Checked)
            {
                if (RLCseriesButton.Checked)
                    tile.m_type = NetworkType.SeriesZserRLC;
                if (RLCparallelButton.Checked)
                    tile.m_type = NetworkType.SeriesZparRLC;
            }
            if (seriesTLbutton.Checked)
                tile.m_type = NetworkType.SeriesTL;
            if (transformerbutton.Checked)
                tile.m_type = NetworkType.Transformer;

            if (pibutton.Checked)
                tile.m_type = NetworkType.PiNet;
            if (teebutton.Checked)
                tile.m_type = NetworkType.TeeNet;

            DialogResult = DialogResult.OK;  // tile was sucessfully specified, exit form
        }
    }
}
