using namespace std;  // must be declared first to get the header files to work correctly

#include <stdio.h>
#include <initguid.h>
#include <Dsound.h>
#include <vector>
#include <string>
#include <iostream>

#include "sdr.h"

#pragma hdrstop

DSCAPS dscaps;
DSBUFFERDESC bd;
DSBCAPS dsbcaps;
LPDIRECTSOUNDBUFFER p_direct_sound_buffer;
WAVEFORMATEX wf;
DWORD   write_position;
DWORD   top_of_buffer;

HRESULT write_output_data(unsigned char buffer[], DWORD bytes_to_write)
{
HRESULT status;
char    *write_pointer_1, *write_pointer_2;
DWORD   write_1_count, write_2_count;
DWORD   write_cursor, play_cursor;

    // this is an error recovery step.  It will cause an audible glitch if it is > top_of_buffer.
    // the logic will occasionally hit this step if the last write pushed us to exactly the top of the buffer
    if (write_position >= top_of_buffer)
    {
       if (write_position != top_of_buffer)
       {
          cout << "above top of out buffer" << endl;
       }
       write_position = 0;
    }
    status = p_direct_sound_buffer->GetCurrentPosition(&write_cursor, &play_cursor);
    status = p_direct_sound_buffer->Lock(write_position, bytes_to_write, (LPVOID *)&write_pointer_1, &write_1_count,
                                                   (LPVOID *)&write_pointer_2, &write_2_count, 
                                                   0);
    if (status !=0)
    {
       cout << "lock failure" << endl;
       status = p_direct_sound_buffer->Unlock((LPVOID *)&write_pointer_1, write_1_count, (LPVOID *)&write_pointer_2, write_2_count); 
       return 0;
    }
    if (write_1_count == 0)
    {
       status = 0;
    }
    else
    {
       memcpy(write_pointer_1, buffer, write_1_count);
       
       if (write_pointer_2 != NULL)
       {
          memcpy(write_pointer_2, &buffer[write_1_count], write_2_count);
          write_position = write_2_count;
       }
       else
       {
          write_position += write_1_count;
       }
    }
    status = p_direct_sound_buffer->Unlock((LPVOID *)write_pointer_1, write_1_count, (LPVOID *)write_pointer_2, write_2_count); 
    status = p_direct_sound_buffer->GetCurrentPosition(&write_cursor, &play_cursor);
    return status;
   
}
HRESULT setup_output_buffer(void)
{
HRESULT status;
DWORD   write_cursor, play_cursor;

   if (FAILED (DirectSoundCreate (output_audio_devices[output_device]->guid, &p_output_object, NULL)))
   {
     cout << "Unable to create the DirectSound Object!!!" << endl;
     return 3;
   }
   dscaps.dwSize = sizeof(DSCAPS); 
   status = p_output_object->GetCaps(&dscaps); 
   if (FAILED(status))
   {
      return(status);
   }
   if (dscaps.dwMaxSecondarySampleRate < DESIRED_SAMPLE_RATE)
   {
      cout << "Max Sample Rate is less than " << DESIRED_SAMPLE_RATE << endl;
      return 5;
   }

   if (FAILED (p_output_object->SetCooperativeLevel (FindWindow (NULL, app_title), DSSCL_PRIORITY)))
   {
       cout << "Unable to set the cooperative level!!!" << endl;
       return 4;
   }
   memset (&bd, 0, sizeof (DSBUFFERDESC));
   bd.dwSize = sizeof (DSBUFFERDESC);
   bd.dwFlags = DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS;
   bd.dwBufferBytes = DESIRED_SAMPLE_RATE * 4;
   bd.lpwfxFormat = &wf;
   top_of_buffer = bd.dwBufferBytes;

   memset (&wf, 0, sizeof (WAVEFORMATEX));
   wf.wFormatTag = WAVE_FORMAT_PCM;
   wf.nChannels = 2;
   wf.nSamplesPerSec = DESIRED_SAMPLE_RATE;
   wf.wBitsPerSample = 16;
   wf.nBlockAlign = 4;
   wf.nAvgBytesPerSec = DESIRED_SAMPLE_RATE * 4;

   status = p_output_object->CreateSoundBuffer (&bd, &p_direct_sound_buffer, NULL);

   status = p_direct_sound_buffer->GetCurrentPosition(&play_cursor, &write_cursor);
   write_position = 0;
// If you want to know the buffer size, call GetCaps. 

   dsbcaps.dwSize = sizeof(DSBCAPS); 
   p_direct_sound_buffer->GetCaps(&dsbcaps);
   top_of_buffer = dsbcaps.dwBufferBytes;
   return status;
}