//----------------------------------------------------------------------------
//	SIMPLE SDR RECEIVER X2 PSoC3 FIRMWARE
//
//	FILTER FIR DATA COEFFICIENTS
//	
//	By Simple Circuits Inc.
//	Mike Hightower
//
//
//	05/11/2011
//
//----------------------------------------------------------------------------
#include "Filter.h"

//
//	Hilbert coefficients, 19.63 ksps, 63 taps, 24 bits
//	http://www-users.cs.york.ac.uk/~fisher/mkfilter/hilbert.html
//
#define NORM	5000000
const int32 CYCODE Hilbert [] =
{
	NORM * +0.0025867224, 0, NORM * +0.0030906200, 0,
    NORM * +0.0043540001, 0, NORM * +0.0065133572, 0,
    NORM * +0.0097218752, 0, NORM * +0.0141608715, 0,
    NORM * +0.0200599432, 0, NORM * +0.0277327299, 0,
    NORM * +0.0376421213, 0, NORM * +0.0505269766, 0,
    NORM * +0.0676671267, 0, NORM * +0.0915013552, 0,
    NORM * +0.1273045540, 0, NORM * +0.1888856888, 0,
    NORM * +0.3270732164, 0, NORM * +0.9999998808, 0,
    NORM * -0.9999998808, 0, NORM * -0.3270732164, 0,
    NORM * -0.1888856888, 0, NORM * -0.1273045540, 0,
    NORM * -0.0915013552, 0, NORM * -0.0676671267, 0,
    NORM * -0.0505269766, 0, NORM * -0.0376421213, 0,
    NORM * -0.0277327299, 0, NORM * -0.0200599432, 0,
    NORM * -0.0141608715, 0, NORM * -0.0097218752, 0,
    NORM * -0.0065133572, 0, NORM * -0.0043540001, 0,
    NORM * -0.0030906200, 0, NORM * -0.0025867224, 0
  };


//
//	FIR LPF, cutoff 2500 Hz, Blackman window, 64 taps
//
const uint8 CYCODE Filter_data_b_2500[] = 
{
    0x00, 0x00, 0x00, 0x00, 0xC9, 0xFF, 0xFF, 0x00,
    0x20, 0xFE, 0xFF, 0x00, 0x97, 0xFD, 0xFF, 0x00,
    0x69, 0x03, 0x00, 0x00, 0xEF, 0x0C, 0x00, 0x00,
    0xB2, 0x0B, 0x00, 0x00, 0x37, 0xF5, 0xFF, 0x00,
    0x68, 0xD9, 0xFF, 0x00, 0xB0, 0xDE, 0xFF, 0x00,
    0x4A, 0x17, 0x00, 0x00, 0xB0, 0x57, 0x00, 0x00,
    0x7D, 0x4C, 0x00, 0x00, 0x69, 0xD6, 0xFF, 0x00,
    0x11, 0x53, 0xFF, 0x00, 0x98, 0x64, 0xFF, 0x00,
    0x4F, 0x41, 0x00, 0x00, 0x83, 0x38, 0x01, 0x00,
    0x6D, 0x24, 0x01, 0x00, 0x53, 0xA3, 0xFF, 0x00,
    0xFA, 0xE6, 0xFD, 0x00, 0x0F, 0xEF, 0xFD, 0x00,
    0x9B, 0x78, 0x00, 0x00, 0xCD, 0x93, 0x03, 0x00,
    0x69, 0xC7, 0x03, 0x00, 0xBE, 0x6E, 0xFF, 0x00,
    0xBE, 0x6D, 0xF9, 0x00, 0xA6, 0x27, 0xF8, 0x00,
    0xD9, 0xA2, 0x00, 0x00, 0xAC, 0x8A, 0x11, 0x00,
    0x3C, 0xA4, 0x22, 0x00, 0x0A, 0xF5, 0x29, 0x00,
    0xE8, 0xEC, 0x22, 0x00, 0xAE, 0xD4, 0x11, 0x00,
    0xE6, 0xA6, 0x00, 0x00, 0x83, 0xE4, 0xF7, 0x00,
    0xD7, 0x26, 0xF9, 0x00, 0x53, 0x67, 0xFF, 0x00,
    0xAC, 0x01, 0x04, 0x00, 0x98, 0xD3, 0x03, 0x00,
    0x2E, 0x82, 0x00, 0x00, 0xB6, 0xBF, 0xFD, 0x00,
    0x41, 0xB1, 0xFD, 0x00, 0x09, 0x99, 0xFF, 0x00,
    0x46, 0x48, 0x01, 0x00, 0xA2, 0x62, 0x01, 0x00,
    0xF5, 0x4A, 0x00, 0x00, 0x7D, 0x4B, 0xFF, 0x00,
    0x8C, 0x34, 0xFF, 0x00, 0x66, 0xCE, 0xFF, 0x00,
    0x99, 0x5C, 0x00, 0x00, 0xEA, 0x6B, 0x00, 0x00,
    0x32, 0x1D, 0x00, 0x00, 0x58, 0xD5, 0xFF, 0x00,
    0x53, 0xCD, 0xFF, 0x00, 0x64, 0xF1, 0xFF, 0x00,
    0x7A, 0x10, 0x00, 0x00, 0x39, 0x13, 0x00, 0x00,
    0x7B, 0x05, 0x00, 0x00, 0x9E, 0xFB, 0xFF, 0x00,
    0xB4, 0xFB, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0x00,
    0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xC9, 0xFF, 0xFF, 0x00,
    0x20, 0xFE, 0xFF, 0x00, 0x97, 0xFD, 0xFF, 0x00,
    0x69, 0x03, 0x00, 0x00, 0xEF, 0x0C, 0x00, 0x00,
    0xB2, 0x0B, 0x00, 0x00, 0x37, 0xF5, 0xFF, 0x00,
    0x68, 0xD9, 0xFF, 0x00, 0xB0, 0xDE, 0xFF, 0x00,
    0x4A, 0x17, 0x00, 0x00, 0xB0, 0x57, 0x00, 0x00,
    0x7D, 0x4C, 0x00, 0x00, 0x69, 0xD6, 0xFF, 0x00,
    0x11, 0x53, 0xFF, 0x00, 0x98, 0x64, 0xFF, 0x00,
    0x4F, 0x41, 0x00, 0x00, 0x83, 0x38, 0x01, 0x00,
    0x6D, 0x24, 0x01, 0x00, 0x53, 0xA3, 0xFF, 0x00,
    0xFA, 0xE6, 0xFD, 0x00, 0x0F, 0xEF, 0xFD, 0x00,
    0x9B, 0x78, 0x00, 0x00, 0xCD, 0x93, 0x03, 0x00,
    0x69, 0xC7, 0x03, 0x00, 0xBE, 0x6E, 0xFF, 0x00,
    0xBE, 0x6D, 0xF9, 0x00, 0xA6, 0x27, 0xF8, 0x00,
    0xD9, 0xA2, 0x00, 0x00, 0xAC, 0x8A, 0x11, 0x00,
    0x3C, 0xA4, 0x22, 0x00, 0x0A, 0xF5, 0x29, 0x00,
    0xE8, 0xEC, 0x22, 0x00, 0xAE, 0xD4, 0x11, 0x00,
    0xE6, 0xA6, 0x00, 0x00, 0x83, 0xE4, 0xF7, 0x00,
    0xD7, 0x26, 0xF9, 0x00, 0x53, 0x67, 0xFF, 0x00,
    0xAC, 0x01, 0x04, 0x00, 0x98, 0xD3, 0x03, 0x00,
    0x2E, 0x82, 0x00, 0x00, 0xB6, 0xBF, 0xFD, 0x00,
    0x41, 0xB1, 0xFD, 0x00, 0x09, 0x99, 0xFF, 0x00,
    0x46, 0x48, 0x01, 0x00, 0xA2, 0x62, 0x01, 0x00,
    0xF5, 0x4A, 0x00, 0x00, 0x7D, 0x4B, 0xFF, 0x00,
    0x8C, 0x34, 0xFF, 0x00, 0x66, 0xCE, 0xFF, 0x00,
    0x99, 0x5C, 0x00, 0x00, 0xEA, 0x6B, 0x00, 0x00,
    0x32, 0x1D, 0x00, 0x00, 0x58, 0xD5, 0xFF, 0x00,
    0x53, 0xCD, 0xFF, 0x00, 0x64, 0xF1, 0xFF, 0x00,
    0x7A, 0x10, 0x00, 0x00, 0x39, 0x13, 0x00, 0x00,
    0x7B, 0x05, 0x00, 0x00, 0x9E, 0xFB, 0xFF, 0x00,
    0xB4, 0xFB, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0x00,
    0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   };
//
//	FIR LPF, cutoff 2000 Hz, Blackman window, 64 taps
//
const uint8 CYCODE Filter_data_b_2000[] =  
{
    0x00, 0x00, 0x00, 0x00, 0xF5, 0xFF, 0xFF, 0x00,
    0x7E, 0xFE, 0xFF, 0x00, 0xBF, 0xFB, 0xFF, 0x00,
    0xE6, 0xFB, 0xFF, 0x00, 0xC5, 0x03, 0x00, 0x00,
    0xBF, 0x11, 0x00, 0x00, 0x0B, 0x1A, 0x00, 0x00,
    0x24, 0x0D, 0x00, 0x00, 0x3F, 0xE7, 0xFF, 0x00,
    0xF0, 0xBC, 0xFF, 0x00, 0xA9, 0xB5, 0xFF, 0x00,
    0x4A, 0xEF, 0xFF, 0x00, 0xE4, 0x5A, 0x00, 0x00,
    0x10, 0xB2, 0x00, 0x00, 0x68, 0x9B, 0x00, 0x00,
    0xD0, 0xF2, 0xFF, 0x00, 0x8E, 0x03, 0xFF, 0x00,
    0x9C, 0x79, 0xFE, 0x00, 0x14, 0xF8, 0xFE, 0x00,
    0x96, 0x8A, 0x00, 0x00, 0x77, 0x5B, 0x02, 0x00,
    0xE9, 0x05, 0x03, 0x00, 0x56, 0x7B, 0x01, 0x00,
    0x0A, 0xFD, 0xFD, 0x00, 0xD3, 0x75, 0xFA, 0x00,
    0xD4, 0xC3, 0xF9, 0x00, 0xC7, 0x28, 0xFE, 0x00,
    0x0B, 0xB9, 0x07, 0x00, 0x67, 0xCB, 0x13, 0x00,
    0xD9, 0xEC, 0x1D, 0x00, 0x21, 0xF7, 0x21, 0x00,
    0xA0, 0x2B, 0x1E, 0x00, 0xEA, 0x1E, 0x14, 0x00,
    0x3D, 0xEA, 0x07, 0x00, 0x06, 0x19, 0xFE, 0x00,
    0x8F, 0x80, 0xF9, 0x00, 0x67, 0x2D, 0xFA, 0x00,
    0x06, 0xDE, 0xFD, 0x00, 0xC3, 0x95, 0x01, 0x00,
    0x5D, 0x43, 0x03, 0x00, 0x7C, 0x91, 0x02, 0x00,
    0x73, 0x98, 0x00, 0x00, 0xC6, 0xDA, 0xFE, 0x00,
    0xC0, 0x49, 0xFE, 0x00, 0x88, 0xE1, 0xFE, 0x00,
    0xDD, 0xF0, 0xFF, 0x00, 0x83, 0xB4, 0x00, 0x00,
    0x7C, 0xD1, 0x00, 0x00, 0x68, 0x6C, 0x00, 0x00,
    0xC5, 0xEB, 0xFF, 0x00, 0x84, 0xA4, 0xFF, 0x00,
    0xEE, 0xAB, 0xFF, 0x00, 0x4E, 0xE0, 0xFF, 0x00,
    0x42, 0x11, 0x00, 0x00, 0x45, 0x23, 0x00, 0x00,
    0x01, 0x19, 0x00, 0x00, 0x9B, 0x05, 0x00, 0x00,
    0x69, 0xF9, 0xFF, 0x00, 0x43, 0xF8, 0xFF, 0x00,
    0x8C, 0xFC, 0xFF, 0x00, 0xD2, 0xFF, 0xFF, 0x00,
    0x4F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xF5, 0xFF, 0xFF, 0x00,
    0x7E, 0xFE, 0xFF, 0x00, 0xBF, 0xFB, 0xFF, 0x00,
    0xE6, 0xFB, 0xFF, 0x00, 0xC5, 0x03, 0x00, 0x00,
    0xBF, 0x11, 0x00, 0x00, 0x0B, 0x1A, 0x00, 0x00,
    0x24, 0x0D, 0x00, 0x00, 0x3F, 0xE7, 0xFF, 0x00,
    0xF0, 0xBC, 0xFF, 0x00, 0xA9, 0xB5, 0xFF, 0x00,
    0x4A, 0xEF, 0xFF, 0x00, 0xE4, 0x5A, 0x00, 0x00,
    0x10, 0xB2, 0x00, 0x00, 0x68, 0x9B, 0x00, 0x00,
    0xD0, 0xF2, 0xFF, 0x00, 0x8E, 0x03, 0xFF, 0x00,
    0x9C, 0x79, 0xFE, 0x00, 0x14, 0xF8, 0xFE, 0x00,
    0x96, 0x8A, 0x00, 0x00, 0x77, 0x5B, 0x02, 0x00,
    0xE9, 0x05, 0x03, 0x00, 0x56, 0x7B, 0x01, 0x00,
    0x0A, 0xFD, 0xFD, 0x00, 0xD3, 0x75, 0xFA, 0x00,
    0xD4, 0xC3, 0xF9, 0x00, 0xC7, 0x28, 0xFE, 0x00,
    0x0B, 0xB9, 0x07, 0x00, 0x67, 0xCB, 0x13, 0x00,
    0xD9, 0xEC, 0x1D, 0x00, 0x21, 0xF7, 0x21, 0x00,
    0xA0, 0x2B, 0x1E, 0x00, 0xEA, 0x1E, 0x14, 0x00,
    0x3D, 0xEA, 0x07, 0x00, 0x06, 0x19, 0xFE, 0x00,
    0x8F, 0x80, 0xF9, 0x00, 0x67, 0x2D, 0xFA, 0x00,
    0x06, 0xDE, 0xFD, 0x00, 0xC3, 0x95, 0x01, 0x00,
    0x5D, 0x43, 0x03, 0x00, 0x7C, 0x91, 0x02, 0x00,
    0x73, 0x98, 0x00, 0x00, 0xC6, 0xDA, 0xFE, 0x00,
    0xC0, 0x49, 0xFE, 0x00, 0x88, 0xE1, 0xFE, 0x00,
    0xDD, 0xF0, 0xFF, 0x00, 0x83, 0xB4, 0x00, 0x00,
    0x7C, 0xD1, 0x00, 0x00, 0x68, 0x6C, 0x00, 0x00,
    0xC5, 0xEB, 0xFF, 0x00, 0x84, 0xA4, 0xFF, 0x00,
    0xEE, 0xAB, 0xFF, 0x00, 0x4E, 0xE0, 0xFF, 0x00,
    0x42, 0x11, 0x00, 0x00, 0x45, 0x23, 0x00, 0x00,
    0x01, 0x19, 0x00, 0x00, 0x9B, 0x05, 0x00, 0x00,
    0x69, 0xF9, 0xFF, 0x00, 0x43, 0xF8, 0xFF, 0x00,
    0x8C, 0xFC, 0xFF, 0x00, 0xD2, 0xFF, 0xFF, 0x00,
    0x4F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   };
//
//	FIR LPF, cutoff 1500 Hz, Blackman window, 64 taps
//
const uint8 CYCODE Filter_data_b_1500[] = 
{
    0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00,
    0x5E, 0xFF, 0xFF, 0x00, 0x65, 0xFC, 0xFF, 0x00,
    0x08, 0xF8, 0xFF, 0x00, 0xF4, 0xF5, 0xFF, 0x00,
    0x3B, 0xFB, 0xFF, 0x00, 0xC9, 0x0A, 0x00, 0x00,
    0x77, 0x21, 0x00, 0x00, 0x42, 0x34, 0x00, 0x00,
    0x3A, 0x33, 0x00, 0x00, 0x71, 0x11, 0x00, 0x00,
    0x4D, 0xCF, 0xFF, 0x00, 0xA5, 0x81, 0xFF, 0x00,
    0xA7, 0x4F, 0xFF, 0x00, 0x98, 0x64, 0xFF, 0x00,
    0x90, 0xD8, 0xFF, 0x00, 0xF2, 0x99, 0x00, 0x00,
    0xC5, 0x64, 0x01, 0x00, 0xEB, 0xD1, 0x01, 0x00,
    0x08, 0x7F, 0x01, 0x00, 0x11, 0x43, 0x00, 0x00,
    0x6E, 0x59, 0xFE, 0x00, 0x33, 0x6C, 0xFC, 0x00,
    0xA9, 0x6F, 0xFB, 0x00, 0xD6, 0x53, 0xFC, 0x00,
    0xB1, 0xA4, 0xFF, 0x00, 0xF0, 0x3D, 0x05, 0x00,
    0xDB, 0x34, 0x0C, 0x00, 0xAA, 0x08, 0x13, 0x00,
    0x0F, 0x0F, 0x18, 0x00, 0x37, 0xF9, 0x19, 0x00,
    0x87, 0x41, 0x18, 0x00, 0xF8, 0x58, 0x13, 0x00,
    0x9C, 0x82, 0x0C, 0x00, 0xCC, 0x6A, 0x05, 0x00,
    0xD8, 0xA0, 0xFF, 0x00, 0xD3, 0x23, 0xFC, 0x00,
    0x4C, 0x29, 0xFB, 0x00, 0x68, 0x2C, 0xFC, 0x00,
    0xE0, 0x37, 0xFE, 0x00, 0x12, 0x49, 0x00, 0x00,
    0x5A, 0xA5, 0x01, 0x00, 0xA7, 0x05, 0x02, 0x00,
    0x82, 0x90, 0x01, 0x00, 0xB2, 0xAE, 0x00, 0x00,
    0xBC, 0xD2, 0xFF, 0x00, 0x7D, 0x4B, 0xFF, 0x00,
    0x88, 0x30, 0xFF, 0x00, 0x4B, 0x69, 0xFF, 0x00,
    0x0C, 0xC5, 0xFF, 0x00, 0x77, 0x15, 0x00, 0x00,
    0x37, 0x40, 0x00, 0x00, 0xEA, 0x42, 0x00, 0x00,
    0xF1, 0x2B, 0x00, 0x00, 0x9C, 0x0E, 0x00, 0x00,
    0x48, 0xF9, 0xFF, 0x00, 0x11, 0xF1, 0xFF, 0x00,
    0x32, 0xF3, 0xFF, 0x00, 0x70, 0xF9, 0xFF, 0x00,
    0x8D, 0xFE, 0xFF, 0x00, 0x8A, 0x00, 0x00, 0x00,
    0x5E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00,
    0x5E, 0xFF, 0xFF, 0x00, 0x65, 0xFC, 0xFF, 0x00,
    0x08, 0xF8, 0xFF, 0x00, 0xF4, 0xF5, 0xFF, 0x00,
    0x3B, 0xFB, 0xFF, 0x00, 0xC9, 0x0A, 0x00, 0x00,
    0x77, 0x21, 0x00, 0x00, 0x42, 0x34, 0x00, 0x00,
    0x3A, 0x33, 0x00, 0x00, 0x71, 0x11, 0x00, 0x00,
    0x4D, 0xCF, 0xFF, 0x00, 0xA5, 0x81, 0xFF, 0x00,
    0xA7, 0x4F, 0xFF, 0x00, 0x98, 0x64, 0xFF, 0x00,
    0x90, 0xD8, 0xFF, 0x00, 0xF2, 0x99, 0x00, 0x00,
    0xC5, 0x64, 0x01, 0x00, 0xEB, 0xD1, 0x01, 0x00,
    0x08, 0x7F, 0x01, 0x00, 0x11, 0x43, 0x00, 0x00,
    0x6E, 0x59, 0xFE, 0x00, 0x33, 0x6C, 0xFC, 0x00,
    0xA9, 0x6F, 0xFB, 0x00, 0xD6, 0x53, 0xFC, 0x00,
    0xB1, 0xA4, 0xFF, 0x00, 0xF0, 0x3D, 0x05, 0x00,
    0xDB, 0x34, 0x0C, 0x00, 0xAA, 0x08, 0x13, 0x00,
    0x0F, 0x0F, 0x18, 0x00, 0x37, 0xF9, 0x19, 0x00,
    0x87, 0x41, 0x18, 0x00, 0xF8, 0x58, 0x13, 0x00,
    0x9C, 0x82, 0x0C, 0x00, 0xCC, 0x6A, 0x05, 0x00,
    0xD8, 0xA0, 0xFF, 0x00, 0xD3, 0x23, 0xFC, 0x00,
    0x4C, 0x29, 0xFB, 0x00, 0x68, 0x2C, 0xFC, 0x00,
    0xE0, 0x37, 0xFE, 0x00, 0x12, 0x49, 0x00, 0x00,
    0x5A, 0xA5, 0x01, 0x00, 0xA7, 0x05, 0x02, 0x00,
    0x82, 0x90, 0x01, 0x00, 0xB2, 0xAE, 0x00, 0x00,
    0xBC, 0xD2, 0xFF, 0x00, 0x7D, 0x4B, 0xFF, 0x00,
    0x88, 0x30, 0xFF, 0x00, 0x4B, 0x69, 0xFF, 0x00,
    0x0C, 0xC5, 0xFF, 0x00, 0x77, 0x15, 0x00, 0x00,
    0x37, 0x40, 0x00, 0x00, 0xEA, 0x42, 0x00, 0x00,
    0xF1, 0x2B, 0x00, 0x00, 0x9C, 0x0E, 0x00, 0x00,
    0x48, 0xF9, 0xFF, 0x00, 0x11, 0xF1, 0xFF, 0x00,
    0x32, 0xF3, 0xFF, 0x00, 0x70, 0xF9, 0xFF, 0x00,
    0x8D, 0xFE, 0xFF, 0x00, 0x8A, 0x00, 0x00, 0x00,
    0x5E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   };
   
//
//	FIR Bandpass Filter, center 1000 Hz, 400 Hz wide, Hamming window, 64 taps
//
const uint8 CYCODE Filter_data_b_cw[] = 
{
    0x68, 0xFD, 0xFF, 0x00, 0xF1, 0xF5, 0xFF, 0x00,
    0xDE, 0xE9, 0xFF, 0x00, 0xE7, 0xD9, 0xFF, 0x00,
    0x65, 0xC8, 0xFF, 0x00, 0x4D, 0xBA, 0xFF, 0x00,
    0x4A, 0xB7, 0xFF, 0x00, 0x99, 0xC8, 0xFF, 0x00,
    0xB8, 0xF6, 0xFF, 0x00, 0x35, 0x46, 0x00, 0x00,
    0x92, 0xB4, 0x00, 0x00, 0x12, 0x36, 0x01, 0x00,
    0x84, 0xB5, 0x01, 0x00, 0x6D, 0x16, 0x02, 0x00,
    0xAD, 0x39, 0x02, 0x00, 0xF4, 0x03, 0x02, 0x00,
    0xC1, 0x64, 0x01, 0x00, 0x72, 0x5C, 0x00, 0x00,
    0xC4, 0xFF, 0xFE, 0x00, 0x97, 0x77, 0xFD, 0x00,
    0x85, 0xFC, 0xFB, 0x00, 0x8D, 0xCE, 0xFA, 0x00,
    0x32, 0x2A, 0xFA, 0x00, 0xF0, 0x3C, 0xFA, 0x00,
    0x50, 0x1B, 0xFB, 0x00, 0xAC, 0xBA, 0xFC, 0x00,
    0x3F, 0xF0, 0xFE, 0x00, 0xF3, 0x75, 0x01, 0x00,
    0x7D, 0xF4, 0x03, 0x00, 0x02, 0x11, 0x06, 0x00,
    0x07, 0x7C, 0x07, 0x00, 0xD3, 0xFE, 0x07, 0x00,
    0xDA, 0x84, 0x07, 0x00, 0x60, 0x1F, 0x06, 0x00,
    0x9E, 0x02, 0x04, 0x00, 0xF5, 0x7C, 0x01, 0x00,
    0xD4, 0xE9, 0xFE, 0x00, 0xB9, 0xA2, 0xFC, 0x00,
    0x0C, 0xF1, 0xFA, 0x00, 0x59, 0x03, 0xFA, 0x00,
    0xA9, 0xE7, 0xF9, 0x00, 0xBB, 0x8B, 0xFA, 0x00,
    0xBD, 0xC2, 0xFB, 0x00, 0x10, 0x4F, 0xFD, 0x00,
    0x0E, 0xEE, 0xFE, 0x00, 0x7A, 0x63, 0x00, 0x00,
    0x87, 0x82, 0x01, 0x00, 0x10, 0x33, 0x02, 0x00,
    0x74, 0x72, 0x02, 0x00, 0x70, 0x50, 0x02, 0x00,
    0x25, 0xE9, 0x01, 0x00, 0xC2, 0x5D, 0x01, 0x00,
    0x91, 0xCD, 0x00, 0x00, 0xAE, 0x50, 0x00, 0x00,
    0x3D, 0xF5, 0xFF, 0x00, 0x36, 0xBF, 0xFF, 0x00,
    0x69, 0xAA, 0xFF, 0x00, 0xB8, 0xAD, 0xFF, 0x00,
    0x91, 0xBE, 0xFF, 0x00, 0xBC, 0xD3, 0xFF, 0x00,
    0xF1, 0xE6, 0xFF, 0x00, 0x11, 0xF5, 0xFF, 0x00,
    0x54, 0xFD, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x68, 0xFD, 0xFF, 0x00, 0xF1, 0xF5, 0xFF, 0x00,
    0xDE, 0xE9, 0xFF, 0x00, 0xE7, 0xD9, 0xFF, 0x00,
    0x65, 0xC8, 0xFF, 0x00, 0x4D, 0xBA, 0xFF, 0x00,
    0x4A, 0xB7, 0xFF, 0x00, 0x99, 0xC8, 0xFF, 0x00,
    0xB8, 0xF6, 0xFF, 0x00, 0x35, 0x46, 0x00, 0x00,
    0x92, 0xB4, 0x00, 0x00, 0x12, 0x36, 0x01, 0x00,
    0x84, 0xB5, 0x01, 0x00, 0x6D, 0x16, 0x02, 0x00,
    0xAD, 0x39, 0x02, 0x00, 0xF4, 0x03, 0x02, 0x00,
    0xC1, 0x64, 0x01, 0x00, 0x72, 0x5C, 0x00, 0x00,
    0xC4, 0xFF, 0xFE, 0x00, 0x97, 0x77, 0xFD, 0x00,
    0x85, 0xFC, 0xFB, 0x00, 0x8D, 0xCE, 0xFA, 0x00,
    0x32, 0x2A, 0xFA, 0x00, 0xF0, 0x3C, 0xFA, 0x00,
    0x50, 0x1B, 0xFB, 0x00, 0xAC, 0xBA, 0xFC, 0x00,
    0x3F, 0xF0, 0xFE, 0x00, 0xF3, 0x75, 0x01, 0x00,
    0x7D, 0xF4, 0x03, 0x00, 0x02, 0x11, 0x06, 0x00,
    0x07, 0x7C, 0x07, 0x00, 0xD3, 0xFE, 0x07, 0x00,
    0xDA, 0x84, 0x07, 0x00, 0x60, 0x1F, 0x06, 0x00,
    0x9E, 0x02, 0x04, 0x00, 0xF5, 0x7C, 0x01, 0x00,
    0xD4, 0xE9, 0xFE, 0x00, 0xB9, 0xA2, 0xFC, 0x00,
    0x0C, 0xF1, 0xFA, 0x00, 0x59, 0x03, 0xFA, 0x00,
    0xA9, 0xE7, 0xF9, 0x00, 0xBB, 0x8B, 0xFA, 0x00,
    0xBD, 0xC2, 0xFB, 0x00, 0x10, 0x4F, 0xFD, 0x00,
    0x0E, 0xEE, 0xFE, 0x00, 0x7A, 0x63, 0x00, 0x00,
    0x87, 0x82, 0x01, 0x00, 0x10, 0x33, 0x02, 0x00,
    0x74, 0x72, 0x02, 0x00, 0x70, 0x50, 0x02, 0x00,
    0x25, 0xE9, 0x01, 0x00, 0xC2, 0x5D, 0x01, 0x00,
    0x91, 0xCD, 0x00, 0x00, 0xAE, 0x50, 0x00, 0x00,
    0x3D, 0xF5, 0xFF, 0x00, 0x36, 0xBF, 0xFF, 0x00,
    0x69, 0xAA, 0xFF, 0x00, 0xB8, 0xAD, 0xFF, 0x00,
    0x91, 0xBE, 0xFF, 0x00, 0xBC, 0xD3, 0xFF, 0x00,
    0xF1, 0xE6, 0xFF, 0x00, 0x11, 0xF5, 0xFF, 0x00,
    0x54, 0xFD, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
   };

/* [] END OF FILE */