/*******************************************************************************
* File Name: GRNLED.h  
* Version 1.50
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2010, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/

#if !defined(CY_PINS_GRNLED_H) /* Pins GRNLED_H */
#define CY_PINS_GRNLED_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "GRNLED_aliases.h"


/***************************************
*        Function Prototypes             
***************************************/    

void    GRNLED_Write(uint8 value) ;
void    GRNLED_SetDriveMode(uint8 mode) ;
uint8   GRNLED_ReadDataReg(void) ;
uint8   GRNLED_Read(void) ;
uint8   GRNLED_ClearInterrupt(void) ;

/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define GRNLED_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define GRNLED_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define GRNLED_DM_RES_UP          PIN_DM_RES_UP
#define GRNLED_DM_RES_DWN         PIN_DM_RES_DWN
#define GRNLED_DM_OD_LO           PIN_DM_OD_LO
#define GRNLED_DM_OD_HI           PIN_DM_OD_HI
#define GRNLED_DM_STRONG          PIN_DM_STRONG
#define GRNLED_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define GRNLED_MASK               GRNLED__MASK
#define GRNLED_SHIFT              GRNLED__SHIFT
#define GRNLED_WIDTH              1u

/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define GRNLED_PS                     (* (reg8 *) GRNLED__PS)
/* Data Register */
#define GRNLED_DR                     (* (reg8 *) GRNLED__DR)
/* Port Number */
#define GRNLED_PRT_NUM                (* (reg8 *) GRNLED__PRT) 
/* Connect to Analog Globals */                                                  
#define GRNLED_AG                     (* (reg8 *) GRNLED__AG)                       
/* Analog MUX bux enable */
#define GRNLED_AMUX                   (* (reg8 *) GRNLED__AMUX) 
/* Bidirectional Enable */                                                        
#define GRNLED_BIE                    (* (reg8 *) GRNLED__BIE)
/* Bit-mask for Aliased Register Access */
#define GRNLED_BIT_MASK               (* (reg8 *) GRNLED__BIT_MASK)
/* Bypass Enable */
#define GRNLED_BYP                    (* (reg8 *) GRNLED__BYP)
/* Port wide control signals */                                                   
#define GRNLED_CTL                    (* (reg8 *) GRNLED__CTL)
/* Drive Modes */
#define GRNLED_DM0                    (* (reg8 *) GRNLED__DM0) 
#define GRNLED_DM1                    (* (reg8 *) GRNLED__DM1)
#define GRNLED_DM2                    (* (reg8 *) GRNLED__DM2) 
/* Input Buffer Disable Override */
#define GRNLED_INP_DIS                (* (reg8 *) GRNLED__INP_DIS)
/* LCD Common or Segment Drive */
#define GRNLED_LCD_COM_SEG            (* (reg8 *) GRNLED__LCD_COM_SEG)
/* Enable Segment LCD */
#define GRNLED_LCD_EN                 (* (reg8 *) GRNLED__LCD_EN)
/* Slew Rate Control */
#define GRNLED_SLW                    (* (reg8 *) GRNLED__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define GRNLED_PRTDSI__CAPS_SEL       (* (reg8 *) GRNLED__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define GRNLED_PRTDSI__DBL_SYNC_IN    (* (reg8 *) GRNLED__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define GRNLED_PRTDSI__OE_SEL0        (* (reg8 *) GRNLED__PRTDSI__OE_SEL0) 
#define GRNLED_PRTDSI__OE_SEL1        (* (reg8 *) GRNLED__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define GRNLED_PRTDSI__OUT_SEL0       (* (reg8 *) GRNLED__PRTDSI__OUT_SEL0) 
#define GRNLED_PRTDSI__OUT_SEL1       (* (reg8 *) GRNLED__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define GRNLED_PRTDSI__SYNC_OUT       (* (reg8 *) GRNLED__PRTDSI__SYNC_OUT) 


#if defined(GRNLED__INTSTAT)  /* Interrupt Registers */

    #define GRNLED_INTSTAT                (* (reg8 *) GRNLED__INTSTAT)
    #define GRNLED_SNAP                   (* (reg8 *) GRNLED__SNAP)

#endif /* Interrupt Registers */

#endif /* End Pins GRNLED_H */


/* [] END OF FILE */
