/*******************************************************************************
* File Name: PWMQ.h  
* Version 1.10
*
* Description:
*  Contains the prototypes and constants for the functions available to the 
*  PWM user module.
*
* Note:
*
********************************************************************************
* Copyright 2008-2009, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
********************************************************************************/



#include "cytypes.h"
#include "cyfitter.h"

#if !defined(CY_PWM_PWMQ_H)
#define CY_PWM_PWMQ_H

#define PWMQ_Resolution 8
#define PWMQ_UsingFixedFunction 0
#define PWMQ_DeadBandMode 0
#define PWMQ_KillModeMinTime 0
#define PWMQ_KillMode 0
#define PWMQ_PWMMode 0
#define PWMQ_PWMModeIsCenterAligned 0
#define PWMQ_DeadBandUsed 0
#define PWMQ_DeadBand2_4 0
#if !defined(PWMQ_PWMUDB_sSTSReg_stsreg__REMOVED)
    #define PWMQ_UseStatus 1
#else
    #define PWMQ_UseStatus 0
#endif
#if !defined(PWMQ_PWMUDB_sCTRLReg_ctrlreg__REMOVED)
    #define PWMQ_UseControl 1
#else
    #define PWMQ_UseControl 0
#endif
#define PWMQ_UseOneCompareMode 1
#define PWMQ_MinimumKillTime 1
#define PWMQ_EnableMode 0

#define PWMQ_CompareMode1SW 0
#define PWMQ_CompareMode2SW 0

/* Use Kill Mode Enumerated Types */
#define PWMQ__B_PWM__DISABLED 0
#define PWMQ__B_PWM__ASYNCHRONOUS 1
#define PWMQ__B_PWM__SINGLECYCLE 2
#define PWMQ__B_PWM__LATCHED 3
#define PWMQ__B_PWM__MINTIME 4


/* Use Dead Band Mode Enumerated Types */
#define PWMQ__B_PWM__DBMDISABLED 0
#define PWMQ__B_PWM__DBM_2_4_CLOCKS 1
#define PWMQ__B_PWM__DBM_256_CLOCKS 2


/* Used PWM Mode Enumerated Types */
#define PWMQ__B_PWM__ONE_OUTPUT 0
#define PWMQ__B_PWM__TWO_OUTPUTS 1
#define PWMQ__B_PWM__DUAL_EDGE 2
#define PWMQ__B_PWM__CENTER_ALIGN 3
#define PWMQ__B_PWM__DITHER 5
#define PWMQ__B_PWM__HARDWARESELECT 4


/* Used PWM Compare Mode Enumerated Types */
#define PWMQ__B_PWM__LESS_THAN 1
#define PWMQ__B_PWM__LESS_THAN_OR_EQUAL 2
#define PWMQ__B_PWM__GREATER_THAN 3
#define PWMQ__B_PWM__GREATER_THAN_OR_EQUAL_TO 4
#define PWMQ__B_PWM__EQUAL 0
#define PWMQ__B_PWM__FIRMWARE 5


/***************************************
 *   Function Prototypes
 **************************************/
void    PWMQ_Start(void);
void    PWMQ_Stop(void);
void    PWMQ_SetInterruptMode(uint8 interruptMode);
uint8   PWMQ_GetInterruptSource(void);
#if (PWMQ_UseStatus || PWMQ_UsingFixedFunction)
	uint8   PWMQ_ReadStatusRegister(void);
#endif
#if (PWMQ_UseControl)
	uint8   PWMQ_ReadControlRegister(void);
	void    PWMQ_WriteControlRegister(uint8 control);
#endif
#if PWMQ_UseOneCompareMode
	#if PWMQ_CompareMode1SW
	void    PWMQ_SetCompareMode(uint8 comparemode);
	#endif
#else
	#if PWMQ_CompareMode1SW
	void    PWMQ_SetCompareMode1(uint8 comparemode);
	#endif
	#if PWMQ_CompareMode2SW
	void    PWMQ_SetCompareMode2(uint8 comparemode);
	#endif
#endif

#if (!PWMQ_UsingFixedFunction)
uint8   PWMQ_ReadCounter(void);
uint8  PWMQ_ReadCapture(void);
#if (PWMQ_UseStatus)
void PWMQ_ClearFIFO(void);
#endif
#endif

void    PWMQ_WriteCounter(uint8 counter);
void    PWMQ_WritePeriod(uint8 period);
uint8   PWMQ_ReadPeriod(void);
#if PWMQ_UseOneCompareMode
    void    PWMQ_WriteCompare(uint8 compare);
    uint8   PWMQ_ReadCompare(void);
#else
    void    PWMQ_WriteCompare1(uint8 compare);
    uint8   PWMQ_ReadCompare1(void);
    void    PWMQ_WriteCompare2(uint8 compare);
    uint8   PWMQ_ReadCompare2(void);
#endif


#if (PWMQ_DeadBandUsed)
	void    PWMQ_WriteDeadTime(uint8 deadtime);
	uint8   PWMQ_ReadDeadTime(void);
#endif

#if ( PWMQ_KillModeMinTime)
	void PWMQ_WriteKillTime(uint8 killtime);
	uint8 PWMQ_ReadKillTime(void);
#endif

/***************************************
 *    Initialization Values
 **************************************/
#define PWMQ_INIT_PERIOD_VALUE        1
#define PWMQ_INIT_COMPARE_VALUE1      1
#define PWMQ_INIT_COMPARE_VALUE2      63
#define PWMQ_INIT_INTERRUPTS_MODE     ((0 << PWMQ_STATUS_TC_INT_EN_MASK_SHIFT) | (0 << PWMQ_STATUS_CMP2_INT_EN_MASK_SHIFT) | (0 << PWMQ_STATUS_CMP1_INT_EN_MASK_SHIFT ) | (0 << PWMQ_STATUS_KILL_INT_EN_MASK_SHIFT ))
#define PWMQ_DEFAULT_COMPARE2_MODE    (1 << PWMQ_CTRL_CMPMODE2_SHIFT)
#define PWMQ_DEFAULT_COMPARE1_MODE    (1 << PWMQ_CTRL_CMPMODE1_SHIFT)
#define PWMQ_INIT_DEAD_TIME           1

/********************************
 ******     Registers       *****
 ******************************** */

#if (PWMQ_UsingFixedFunction)
   #define PWMQ_PERIOD_LSB      (*(reg16 *) PWMQ_PWMHW__PER0)
   #define PWMQ_PERIOD_LSB_PTR   ((reg16 *) PWMQ_PWMHW__PER0)
   #define PWMQ_COMPARE1_LSB    (*(reg16 *) PWMQ_PWMHW__CNT_CMP0)
   #define PWMQ_COMPARE1_LSB_PTR ((reg16 *) PWMQ_PWMHW__CNT_CMP0)
   #define PWMQ_COMPARE2_LSB     0x00u
   #define PWMQ_COMPARE2_LSB_PTR 0x00u
   #define PWMQ_COUNTER_LSB     (*(reg16 *) PWMQ_PWMHW__CNT_CMP0)
   #define PWMQ_COUNTER_LSB_PTR  ((reg16 *) PWMQ_PWMHW__CNT_CMP0)
   #define PWMQ_CAPTURE_LSB     (*(reg16 *) PWMQ_PWMHW__CAP0)
   #define PWMQ_CAPTURE_LSB_PTR  ((reg16 *) PWMQ_PWMHW__CAP0)
   
#else
   #if(PWMQ_PWMModeIsCenterAligned)
       #define PWMQ_PERIOD_LSB      (*(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__D1_REG)
       #define PWMQ_PERIOD_LSB_PTR   ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__D1_REG)
   #else
       #define PWMQ_PERIOD_LSB      (*(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__F0_REG)
       #define PWMQ_PERIOD_LSB_PTR   ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__F0_REG)
   #endif
   #define PWMQ_COMPARE1_LSB    (*(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__D0_REG)
   #define PWMQ_COMPARE1_LSB_PTR ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__D0_REG)
   #define PWMQ_COMPARE2_LSB    (*(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__D1_REG)
   #define PWMQ_COMPARE2_LSB_PTR ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__D1_REG)
   #define PWMQ_COUNTERCAP_LSB   *(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__A1_REG)
   #define PWMQ_COUNTERCAP_LSB_PTR ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__A1_REG)
   #define PWMQ_COUNTER_LSB     (*(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__A0_REG)
   #define PWMQ_COUNTER_LSB_PTR  ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__A0_REG)
   #define PWMQ_CAPTURE_LSB     (*(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__F1_REG)
   #define PWMQ_CAPTURE_LSB_PTR  ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__F1_REG)
   #define PWMQ_AUX_CONTROLDP0      (*(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__DP_AUX_CTL_REG)
   #define PWMQ_AUX_CONTROLDP0_PTR  ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u0__DP_AUX_CTL_REG)
   #if (PWMQ_Resolution == 16)
       #define PWMQ_AUX_CONTROLDP1    (*(reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u1__DP_AUX_CTL_REG)
       #define PWMQ_AUX_CONTROLDP1_PTR  ((reg8 *) PWMQ_PWMUDB_sP8_pwmdp_u1__DP_AUX_CTL_REG)
   #endif
#endif
   
#if(PWMQ_KillModeMinTime )
    #define PWMQ_KILLMODEMINTIME      (*(reg8 *) PWMQ_PWMUDB_sKM_killmodecounterdp_u0__D0_REG)
    #define PWMQ_KILLMODEMINTIME_PTR   ((reg8 *) PWMQ_PWMUDB_sKM_killmodecounterdp_u0__D0_REG)
    /* Fixed Function Block has no Kill Mode parameters because it is Asynchronous only */
#endif

#if(PWMQ_DeadBandMode == PWMQ__B_PWM__DBM_256_CLOCKS)
    #define PWMQ_DEADBAND_COUNT        (*(reg8 *) PWMQ_PWMUDB_sDB255_deadbandcounterdp_u0__D0_REG)
    #define PWMQ_DEADBAND_COUNT_PTR     ((reg8 *) PWMQ_PWMUDB_sDB255_deadbandcounterdp_u0__D0_REG)
#elif(PWMQ_DeadBandMode == PWMQ__B_PWM__DBM_2_4_CLOCKS)
    /* In Fixed Function Block these bits are in the control blocks control register */
    #if (PWMQ_UsingFixedFunction)
        #define PWMQ_DEADBAND_COUNT        (*(reg8 *) PWMQ_PWMHW__CFG0) 
        #define PWMQ_DEADBAND_COUNT_PTR     ((reg8 *) PWMQ_PWMHW__CFG0)
        #define PWMQ_DEADBAND_COUNT_MASK    (0x03u << PWMQ_DEADBAND_COUNT_SHIFT) 
        #define PWMQ_DEADBAND_COUNT_SHIFT   0x06u /* As defined by the Register Map as DEADBAND_PERIOD[1:0] in CFG0 */ 
    #else
        /* Lower two bits of the added control register define the count 1-3 */
        #define PWMQ_DEADBAND_COUNT        (*(reg8 *) PWMQ_PWMUDB_sDB3_dbctrlreg__CONTROL_REG)
        #define PWMQ_DEADBAND_COUNT_PTR     ((reg8 *) PWMQ_PWMUDB_sDB3_dbctrlreg__CONTROL_REG)
        #define PWMQ_DEADBAND_COUNT_MASK    (0x03u << PWMQ_DEADBAND_COUNT_SHIFT) 
        #define PWMQ_DEADBAND_COUNT_SHIFT   0x00u /* As defined by the verilog implementation of the Control Register */
    #endif
#endif



#if (PWMQ_UsingFixedFunction)
    #define PWMQ_STATUS                (*(reg8 *) PWMQ_PWMHW__SR0)
    #define PWMQ_STATUS_MASK           (*(reg8 *) PWMQ_PWMHW__SR0)
    #define PWMQ_CONTROL               (*(reg8 *) PWMQ_PWMHW__CFG0)
    #define PWMQ_CONTROL2              (*(reg8 *) PWMQ_PWMHW__CFG1)
    #define PWMQ_GLOBAL_ENABLE         (*(reg8 *) PWMQ_PWMHW__PM_ACT_CFG)

    /***********************************
    *     Constants
    ***********************************/
    /* Fixed Function Block Chosen */
    #define PWMQ_BLOCK_EN_MASK          PWMQ_PWMHW__PM_ACT_MSK
    /* Control Register definitions */
    #define PWMQ_CTRL_ENABLE_SHIFT      0x00u
    #define PWMQ_CTRL_RESET_SHIFT       0x00u   /* Not available in Fixed Function Block */
    #define PWMQ_CTRL_CMPMODE2_SHIFT    0x00u   /* Not available in Fixed Function Block */
    #define PWMQ_CTRL_CMPMODE1_SHIFT    0x01u   /* As defined by Register map as MODE_CFG bits in CFG1*/
    #define PWMQ_CTRL_DEAD_TIME_SHIFT   0x06u   /* As defined by Register map */
    /* Fixed Function Block Only CFG register bit definitions */
    #define PWMQ_CFG0_MODE              0x03u   /* Enable the block to run and set to compare mode */
    #define PWMQ_CFG0_DB                0x20u   /* As defined by Register map as DB bit in CFG0 */

    /* Control Register Bit Masks */
    #define PWMQ_CTRL_ENABLE            (0x01u << PWMQ_CTRL_ENABLE_SHIFT)
    #define PWMQ_CTRL_RESET             (0x01u << PWMQ_CTRL_RESET_SHIFT)
    #define PWMQ_CTRL_CMPMODE2_MASK     (0x07u << PWMQ_CTRL_CMPMODE2_SHIFT)
    #define PWMQ_CTRL_CMPMODE1_MASK     (0x07u << PWMQ_CTRL_CMPMODE1_SHIFT)
    
    /* Control2 Register Bit Masks */
    #define PWMQ_CTRL2_IRQ_SEL_SHIFT    0x00u       /* As defined in Register Map, Part of the TMRX_CFG1 register */
    #define PWMQ_CTRL2_IRQ_SEL          (0x01u << PWMQ_CTRL2_IRQ_SEL_SHIFT)  
    
    /* Status Register Bit Locations */
    #define PWMQ_STATUS_KILL_SHIFT          0x00u   /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_FIFONEMPTY_SHIFT    0x00u   /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_FIFOFULL_SHIFT      0x00u   /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_TC_SHIFT            0x07u   /* As defined by Register map as TC in SR0 */
    #define PWMQ_STATUS_CMP2_SHIFT          0x00u   /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_CMP1_SHIFT          0x06u   /* As defined by the Register map as CAP_CMP in SR0 */
    /* Status Register Interrupt Enable Bit Locations */
    #define PWMQ_STATUS_KILL_INT_EN_MASK_SHIFT          (0x00u)    /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_FIFONEMPTY_INT_EN_MASK_SHIFT    (0x00u)   /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_FIFOFULL_INT_EN_MASK_SHIFT      (0x00u)   /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_TC_INT_EN_MASK_SHIFT            (PWMQ_STATUS_TC_SHIFT - 4)
    #define PWMQ_STATUS_CMP2_INT_EN_MASK_SHIFT          (0x00u)   /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_CMP1_INT_EN_MASK_SHIFT          (PWMQ_STATUS_CMP1_SHIFT - 4)
    /* Status Register Bit Masks */
    #define PWMQ_STATUS_KILL            (0x00u) /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_FIFONEMPTY      (0x00u) /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_FIFOFULL        (0x00u) /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_TC              (0x01u << PWMQ_STATUS_TC_SHIFT)
    #define PWMQ_STATUS_CMP2            (0x00u) /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_CMP1            (0x01u << PWMQ_STATUS_CMP1_SHIFT)
    /* Status Register Interrupt Bit Masks*/
    #define PWMQ_STATUS_KILL_INT_EN_MASK            (0x00u) /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_FIFONEMPTY_INT_EN_MASK      (0x00u) /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_FIFOFULL_INT_EN_MASK        (0x00u) /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_TC_INT_EN_MASK              (PWMQ_STATUS_TC >> 4)
    #define PWMQ_STATUS_CMP2_INT_EN_MASK            (0x00u) /* Not available in Fixed Function Block */
    #define PWMQ_STATUS_CMP1_INT_EN_MASK            (PWMQ_STATUS_CMP1 >> 4)

    /* Datapath Auxillary Control Register definitions */
    //#define PWMQ_AUX_CTRL_FIFO0_CLR         0x01u   /* As defined by Register map */
    //#define PWMQ_AUX_CTRL_FIFO1_CLR       0x02u   /* As defined by Register map */
    //#define PWMQ_AUX_CTRL_FIFO0_LVL       0x04u   /* As defined by Register map */
    //#define PWMQ_AUX_CTRL_FIFO1_LVL       0x08u   /* As defined by Register map */
    //#define PWMQ_STATUS_ACTL_INT_EN_MASK    0x10u   /* As defined for the ACTL Register */
#else
    #define PWMQ_STATUS                (*(reg8 *) PWMQ_PWMUDB_sSTSReg_stsreg__STATUS_REG )
    #define PWMQ_STATUS_MASK           (*(reg8 *) PWMQ_PWMUDB_sSTSReg_stsreg__MASK_REG)
    #define PWMQ_STATUS_AUX_CTRL       (*(reg8 *) PWMQ_PWMUDB_sSTSReg_stsreg__STATUS_AUX_CTL_REG)
    #define PWMQ_CONTROL               (*(reg8 *) PWMQ_PWMUDB_sCTRLReg_ctrlreg__CONTROL_REG)
    /***********************************
    *     Constants
    ***********************************/
    /* Control Register definitions */
    #define PWMQ_CTRL_ENABLE_SHIFT      0x07u
    #define PWMQ_CTRL_RESET_SHIFT       0x06u
    #define PWMQ_CTRL_CMPMODE2_SHIFT    0x03u
    #define PWMQ_CTRL_CMPMODE1_SHIFT    0x00u
	#define PWMQ_CTRL_DEAD_TIME_SHIFT   0x00u   /* No Shift Needed for UDB block */
    /* Control Register Bit Masks */
    #define PWMQ_CTRL_ENABLE            (0x01u << PWMQ_CTRL_ENABLE_SHIFT)
    #define PWMQ_CTRL_RESET             (0x01u << PWMQ_CTRL_RESET_SHIFT)
    #define PWMQ_CTRL_CMPMODE2_MASK     (0x07u << PWMQ_CTRL_CMPMODE2_SHIFT)
    #define PWMQ_CTRL_CMPMODE1_MASK     (0x07u << PWMQ_CTRL_CMPMODE1_SHIFT) 
    
    /* Status Register Bit Locations */
    #define PWMQ_STATUS_KILL_SHIFT          0x05u
    #define PWMQ_STATUS_FIFONEMPTY_SHIFT    0x04u
    #define PWMQ_STATUS_FIFOFULL_SHIFT      0x03u  
    #define PWMQ_STATUS_TC_SHIFT            0x02u
    #define PWMQ_STATUS_CMP2_SHIFT          0x01u
    #define PWMQ_STATUS_CMP1_SHIFT          0x00u
    /* Status Register Interrupt Enable Bit Locations - UDB Status Interrupt Mask match Status Bit Locations*/
    #define PWMQ_STATUS_KILL_INT_EN_MASK_SHIFT          PWMQ_STATUS_KILL_SHIFT          
    #define PWMQ_STATUS_FIFONEMPTY_INT_EN_MASK_SHIFT    PWMQ_STATUS_FIFONEMPTY_SHIFT    
    #define PWMQ_STATUS_FIFOFULL_INT_EN_MASK_SHIFT      PWMQ_STATUS_FIFOFULL_SHIFT        
    #define PWMQ_STATUS_TC_INT_EN_MASK_SHIFT            PWMQ_STATUS_TC_SHIFT            
    #define PWMQ_STATUS_CMP2_INT_EN_MASK_SHIFT          PWMQ_STATUS_CMP2_SHIFT          
    #define PWMQ_STATUS_CMP1_INT_EN_MASK_SHIFT          PWMQ_STATUS_CMP1_SHIFT   
    /* Status Register Bit Masks */
    #define PWMQ_STATUS_KILL            (0x00u << PWMQ_STATUS_KILL_SHIFT )
    #define PWMQ_STATUS_FIFOFULL        (0x01u << PWMQ_STATUS_FIFOFULL_SHIFT)
    #define PWMQ_STATUS_FIFONEMPTY      (0x01u << PWMQ_STATUS_FIFONEMPTY_SHIFT)
    #define PWMQ_STATUS_TC              (0x01u << PWMQ_STATUS_TC_SHIFT)
    #define PWMQ_STATUS_CMP2            (0x01u << PWMQ_STATUS_CMP2_SHIFT) 
    #define PWMQ_STATUS_CMP1            (0x01u << PWMQ_STATUS_CMP1_SHIFT)
    /* Status Register Interrupt Bit Masks  - UDB Status Interrupt Mask match Status Bit Locations */
    #define PWMQ_STATUS_KILL_INT_EN_MASK            PWMQ_STATUS_KILL
    #define PWMQ_STATUS_FIFOFULL_INT_EN_MASK        PWMQ_STATUS_FIFOFULL
    #define PWMQ_STATUS_FIFONEMPTY_INT_EN_MASK      PWMQ_STATUS_FIFONEMPTY
    #define PWMQ_STATUS_TC_INT_EN_MASK              PWMQ_STATUS_TC
    #define PWMQ_STATUS_CMP2_INT_EN_MASK            PWMQ_STATUS_CMP2
    #define PWMQ_STATUS_CMP1_INT_EN_MASK            PWMQ_STATUS_CMP1
                                                          
    /* Datapath Auxillary Control Register definitions */
    #define PWMQ_AUX_CTRL_FIFO0_CLR     0x01u
    #define PWMQ_AUX_CTRL_FIFO1_CLR     0x02u
    #define PWMQ_AUX_CTRL_FIFO0_LVL     0x04u
    #define PWMQ_AUX_CTRL_FIFO1_LVL     0x08u
    #define PWMQ_STATUS_ACTL_INT_EN_MASK  0x10u /* As defined for the ACTL Register */
#endif /* PWMQ_UsingFixedFunction */

#endif  /* CY_PWM_PWMQ_H */
