;---------------------------------------------------------
; RETUNE.ASM from FIR.ASM
; Robert Dick 1998
; Please address comments to rdick@writeme.com
;-----------------------------------------
; FIR.ASM:
; Keith Larson
; TMS320 DSP Applications
; (C) Copyright 1995,1996
; Texas Instruments Incorporated
;--------------------------------------------
; This is unsupported freeware with no implied waranties or
; liabilities.  See the disclaimer document for details
;
; This example can either be loaded and run from the debugger
; or by directly loading and running from DSK3LOAD
;---------------------------------------------------------
; Define constants used by program    ;
TA        .set     20  ; orig  8      ; AIC timing register values
TB        .set     32  ; orig 16      ; Smp Rt 9765.625 Hz
RA        .set     20  ; orig  8      ; LwPss 3906.25 Hz = 0.4 smp rt
RB        .set     32  ; orig 16      ; HiPss 325.5 Hz
GIE       .set     0x2000             ; This bit in ST turns on interrupts
	  .include "C3XMMRS.ASM"      ;
	  .start   "AICTEST",0x809820 ; Start assembling here
	  .sect    "AICTEST"          ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; 32 bit float data buffer of incoming data from the AIC
; The location in memory must be on a 2^N boundary for size (2^N)-1 and the
; size of the coefs table is 1/4 that of the data +1 (for hilbert trans)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
HILB_recv    .float    0,0,0,0,0,0,0,0  ;
	     .float    0,0,0,0,0,0,0,0  ;
	     .float    0,0,0,0,0,0,0,0  ;
	     .float    0,0,0,0,0,0,0    ;  Length 31 so on adr%32==0 OK
;- - - - - - - - - - - - - - - - - - - - - - - - -
; Coefficients for the decimation filter go here
decfilt .float  0, 0.0364, 0, -.0340    ;
	.float  0, 0.0550, 0, -.1008    ;
	.float  0, 0.3165, 0.5          ;
;- - - - - - - - - - - - - - - - - - - - - - - - -
; HILB filter coefficients
;- - - - - - - - - - - - - - - - - - - - - - - - -
HILB_coef    .float    0.0205         ;  HILBert filter coefficients
	     .float    0.0213         ;
	     .float    0.0326         ;  Hilbert transform
	     .float    0.0488         ;  Every 2nd tap 0
	     .float    0.0730         ;  0-valued taps omitted
	     .float    0.1140         ;
	     .float    0.2040         ;
	     .float    0.6338         ;  Antisymmetric 2nd half omitted
END_coef
;---------------------------------------------------------------------
;         MAIN COMPUTATION ARRAYS:
;-------------------------------------------------
xr      .space  256             ; CCOR reals   
xi      .space  256             ; CCOR imags
bins    .space  450             ; 100 is min hist size
endbins                         ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
BufSz        .set      31    ;  So bufadr%32==0 OK.  Size of both bufs.
HilbSz       .set      END_coef - HILB_coef
;- - - - - - - - - - - - - - - - - - -
BFSIZE       .word    BufSz           ; Size of each buffer
HILB_first   .word    HILB_recv
HILB_end     .word    HILB_recv+BufSz
HILB_last    .word    HILB_recv
HILB_coefx   .word    HILB_coef
HILBSIZE     .word    HilbSz
ANG_real     .float   1.0       ; 
ANG_imag     .float   0.0       ;
NwA_real     .float   1.0       ;  New samp-to-samp phase angle real                            
NwA_imag     .float   0.0       ;  New samp-to-samp phase angle imag
DCterm  .word   0       ;  DAC DC term
NwDCterm .word  0       ;  New DAC DC term
adcfl   .word   decfilt ;  Addr dec by 1/2 filter coefficients
nfs     .float  0.      ;  Normalized freq shift versus sampl rate
CX_real      .float   1.0       ;  (Retuning) complex exponential real
CX_imag      .float   0.0       ;  (Retuning) complex exponential imag
MIDSAMP      .float   0.0       ;  Sample at middle of Hilbert filter
xrp     .word   xr      ;  xr FFT real vector pointer
dattrig .word   0       ;  FFT data request/trigger
datrdy  .word   0       ;  FFT data ready flag
fftc    .word   0       ;  Count of CCORs so far this time interval
offtc   .word   0       ;  Count of CCORs, previous time interval
incrsum .float  0.0     ;  Increments sum so far this time interval
eltim   .word   0       ;  Elapsed time since last clock reset
longt   .word   585938  ;  60 seconds, time til retune (random mode)
nwait   .word   976     ;  0.1 second, time til FFTs start (auto mode)
tuntim  .word   80000   ;  8+ seconds, time til retune (auto mode)
;------------------------------------
; Define some constant storage data
;------------------------------------
A_REG        .word  (TA<<9)+(RA<<2)+0 ; A registers
B_REG        .word  (TB<<9)+(RB<<2)+2 ; B registers
C_REG        .word  00000111b ; Enbl hipass control orig 00000011b
S0_gctrl_val .word  0x0E970300        ; Serial port control register values
S0_xctrl_val .word  0x00000111        ;
S0_rctrl_val .word  0x00000111        ;
;****************************************************
; Begin main code loop here
;****************************************************
ithrpct .word   64              ; Init window threshold in percent
imnwd   .word   32              ; Init num bins allowing retun
itnmode .word   1               ; Init tun mode <0: rand, 0: const, >0 auto
intun   .word   0               ; Initial tuning
main                            ;
	ldi     @ithrpct,AR4    ;
	ldi     @imnwd,AR5      ;
	ldi     @itnmode,AR6    ;
	ldi     @intun,AR7      ;
bglp1                           ; *
	ldi     0,R0            ; |
	sti     R0,@dattrig     ; | Reset FFT data request/trigger
	sti     R0,@datrdy      ; | Reset FFT data ready flag
	sti     R0,@eltim       ; | Reset main clock elapsed time
	or      GIE,ST          ; | Turn on INTS
	ldi     0xF4,IE         ; | Enable XINT/RINT/INT2
	cmpi    0,AR6           ; | Tuning mode
	bgt     fullop          ; | v If tunmode > 0, full operation
	bz      bgon1           ; | | v If ==, fixed retuning
	call prnum              ; | | | If <, pseudorandom retuning
bgon1                           ; | | *
	call calcang            ; | | Not full operation
bglp2                           ; | | * Wait for long time limit
	ldi     @eltim,R1       ; | | |
	cmpi    @longt,R1       ; | | |
	blt     bglp2           ; | | ^
	b       bglp1           ; ^ | Long time done.  Start over
;-------------------------------; | |
fullop                          ; | * Full operation
	ldi     @fftc,R1        ; | Count of CCORS
	sti     R1,@offtc       ; | Save prev count for perf monitoring
	ldi     0,R0            ; |
	sti     R0,@fftc        ; |
	ldf     0.,R0           ; | Floating point zero
	stf     R0,@incrsum     ; | Reset hist increments sum
	ldi     @alwbin,AR0     ; | Zero histogram
	ldi     @abinend,R1     ; |
	subi    AR0,R1          ; |
	subi    1,R1            ; | Rpt ct = num bins - 1
	ldi     R1,RC           ; | 
	rptb    zh              ; | Interruptible
zh      stf     R0,*AR0++       ; | * Hist = zeroes
folp1                           ; | *
	ldi     @eltim,R1       ; | | Wait before estimating
	cmpi    @nwait,R1       ; | |
	blt     folp1           ; | ^
	ldi     @axr,AR0        ; | Reset xr FFT vector pointer
	sti     AR0,@xrp        ; |
	ldi     1,R1            ; |
	sti     R1,@dattrig     ; | Set data trigger
folp2                           ; | *
folp3                           ; | | *
	ldi     @datrdy,R1      ; | | | Wait until data ready
	ble     folp3           ; | | ^
	ldi     0,R0            ; | |
	sti     R0,@dattrig     ; | | Reset data trigger
	sti     R0,@datrdy      ; | | Reset data ready flag
	call    ccor            ; | | Complex correlation
	call    ccsrch          ; | | Process CCOR output
	ldi     @fftc,R2        ; | |
	addi    1,R2            ; | | Increment CCOR count
	sti     R2,@fftc        ; | |
	ldi     @axr,AR0        ; | | Reset xr FFT vector pointer
	sti     AR0,@xrp        ; | |
	ldi     1,R1            ; | |
	sti     R1,@dattrig     ; | | Set data trigger
	call    inchist         ; | | Increment histogram
	ldf     @incrsum,R2     ; | |
	addf    @curpow,R2        ; | | Update increments sum
	stf     R2,@incrsum     ; | |
	ldi     @eltim,R1       ; | |
	cmpi    @tuntim,R1      ; | | Time to estimate mistuning?
	blt     folp2           ; | ^ If not go wait for more data
	ldi     AR4,R1          ; | Pct of incrsum for win thresh
	float   R1,R1           ; |
	mpyf    0.01,R1         ; |
	mpyf    R1,R2           ; |
	stf     R2,@thresh      ; |
	call    srchist         ; | Search histogram for narrow peak
	call    calcsft         ; | Calculate corrective frequency shift
	call    calcang         ; | Calculate retuning parameters
	b       bglp1           ; ^
;--------------------------------------------------------------------
tnfctr  .float  976.5625        ; Sample rate Hz / 10
flim    .float  440.            ; Max pseudorandom frequency
prnum                           ; > Generate pseudorandom freq shift
	call rangen             ;
	mpyf    @flim,R0        ;
	fix     R0,R0           ;
	addi    330,R0          ; Range -110 to +770
	ldi     R0,AR7          ; Retuning-to-be in Hz
	rets
;-------------------------------------------------------------------
DCfact  .float  32768./30000.   ; Scale 10 per millivolt
fsr     .float  9765.625        ; Floating point sampl rate Hz
rsr     .float  1./9765.625     ; Reciprocal of sampling rate Hz
calcang                         ; >
	ldi     AR7,R6          ; Hz
	float   R6,R6           ; Floating point Hz
	ldf     R6,R1           ; Ditto
	mpyf    @DCfact,R1      ;
	fix     R1,R1           ;
	addi    1092,R1         ; Add 100 millivolts
	sti     R1,@NwDCterm     ;
	mpyf    @rsr,R6         ; Times recip samp rate
	stf     R6,@nfs         ; Normalized freq shift vesus samp rate
	ldf     7.,R7           ; For sine power series
	call    sinef           ; R7 = sine(R6) STORE IT LAST
	mpyf3   R7,R7,R6        ; sine^2
	subrf   1.,R6           ; 1. - sine^2
	ldi     11,RC           ; For square root
	ldf     R6,R0           ; 1.-sine^2
	call    rsqrt           ; R1 = recip sqrt
	mpyf    R1,R6           ;
	stf     R6,@NwA_real    ; cos = sqrt(1-sine^2)
	stf     R7,@NwA_imag    ; Sine.  Done last because is trigger
	rets                    ; <
;--------------------------------------------------------------
rsqrt                           ; >
	; Entry x in R0, (iterations to do - 1) in RC
	; Needs x > 0 but does not check for it
	; Exit x/2 in R0, 1/sqrt(x) in R1;  1/x in R2;  RC lost
	pushf   R0              ; x
	pop     R1              ;
	ash     -24,R1          ; exp of x
	addi    1,R1            ; round
	ash     -1,R1           ; exp/2
	negi    R1,R1           ; -exp/2
	ash     24,R1           ;
	push    R1              ;
	popf    R1              ; y = 1.*2^(-exp/2)
	mpyf    0.5,R0          ; x/2
	rptb    rsbend          ;
	mpyf3   R1,R1,R2        ; * y*y
	mpyf    R0,R2           ; ^ x*y*y/2
	subrf   1.5,R2          ; | 1.5-x*y*y/2
	mpyf    R2,R1           ; | y
rsbend  rnd     R1,R1           ; * 32-bit y = 1/sqrt(x)
	mpyf3   R1,R1,R2        ; 1/x
	rets                    ; <
;---------------------------------------------|
twopi   .float  2.*3.1415926536
sinef   ;  Sine entry for units of full cycle == 1.
	mpyf    @twopi,R6       ;  R6==angle in radians
sine    ;  Power series expansion of sine.  Best for |R6| < 1.
	;  R7 is floating point odd integer
	;  R6 is angle in radians
	mpyf3   R6,R6,R5        ;  Angle squared
	ldf     1.,R4           ;  Computational term = 1.
snlp                            ; *
	ldf     R7,R0           ; | den = k
	subf    1.,R7           ; |
	mpyf    R7,R0           ; | den = k * (k-1)
	subf    1.,R7           ; |
	ble     sndn            ; v
	ldi     7,RC            ; | Rpt count for inverse
	call    rsqrt           ; | R2 = 1. / den
	mpyf    R2,R4           ; | term = term / den
	mpyf    R5,R4           ; | term = term * angle^2
	subrf   1.,R4           ; | term = 1. - term
	b       snlp            ; ^
	;-----------------------| |
sndn                            ; *
	mpyf3   R6,R4,R7        ; R7 = sine = term * angle
	rets                    ; <
;-------------------------------|------------------------------
mask24  .word   0XFFFFFF        ;  24 bits
twom23  .float  pow(2.,-23)     ;  2^-23
seed    .word   1               ;  must be odd
;-------------------------------|-------------
setseed sti     R0,@seed
rangen  ldi     @seed,R0        ;  must be odd
	mpyi    16807,R0        ;  0X41A7.  Gives max length sequence
	and     @mask24,R0      ;  hold at 24 bits
	sti     R0,@seed        ;  save for next time
	float   R0,R0           ;  0. < R0 < 2.^24
	mpyf    @twom23,R0      ;  0. < R0 < 2.
	subf    1.,R0           ; -1. < R0 < 1.
	rets
;-------------------------------------------------------------------
;  SOME KEY ROUTINES:           ;
;-------------------------------|
	
;       .include "CCOR.ASM"
;  CCOR.ASM  ffts.c translated to TMS320C3x assembly language
;  AR4-7, IR1, R0-1 not used
;------------------------------------------------------------
n       .set    256             ;                     
pi      .set    3.14159265359   ;
jump    .set    n * 0.5         ;
	.float  cos(pi/n)       ; Used for initial value of
	.float  sin(pi/n)       ;    raised cosine window
twids                           ; Table of twiddle factors
	.loop 8                 ; Should be in data memory to
	.float  cos(pi/jump)    ; avoid conflict with instruction
	.float  sin(pi/jump)    ; fetching
jump    .sdef   jump * 0.5      ;
	.endloop                ;
twide                           ;
;-------------------------------|--------------------------------
axr     .word   xr              ; Address of xr reals vector                        ;
axi     .word   xi              ; Address of xi imags vector                        ;
atwids  .word   twids           ; Address of first twiddle factor
atwide  .word   twide           ; First address after twiddle factors
;-------------------------------|------------------------------------
fwfft   ldi     @atwids,AR0     ; @twst (Entry point)
	ldi     n,IR0           ; jump = n
fwlp1                           ; jump > 1        
	lsh     -1,IR0          ; ^ jump >>=1
	ldf     1.,R4           ; | turnr = 1.0
	ldf     0.,R5           ; | turni = 0.0
	ldi     0,AR1           ; | idx = 0
fwlp2                           ; | idx < jump
	ldi     AR1,AR2         ; | ^
	ldi     AR1,AR3         ; | |
	addi    @axr,AR2        ; | | @xr[idx]
	addi    @axi,AR3        ; | | @xi[idx]
fwlp3                           ; | | iptr < n
	ldf     *AR2,R2         ; | | ^ xr[iptr] load
     || ldf     *AR3,R3         ; | | | xi[iptr] load
	subf3   *AR2(IR0),R2,R6 ; | | | tmpr
	subf3   *AR3(IR0),R3,R7 ; | | | tmpi
	addf    *AR2(IR0),R2    ; | | |
	addf    *AR3(IR0),R3    ; | | |
	stf     R2,*AR2         ; | | | xr[iptr] store
     || stf     R3,*AR3         ; | | | xi[iptr] store
	call    cm4567          ; | | | (67)=(45)*(67); (23) lost
	stf     R6,*++AR2(IR0)  ; | | | xr[jptr] store
     || stf     R7,*++AR3(IR0)  ; | | | xi[jptr] store
	ldf     *AR2++(IR0),R6  ; | | | iptr updated for real parts
     || ldf     *AR3++(IR0),R7  ; | | | iptr updated for imag parts
	cmpi    @axi,AR2        ; | | | iptr < n? (For xi's follow xr's)
	blt     fwlp3           ; | | ^
	ldf     *AR0,R6         ; | | twstr load
     || ldf     *+AR0(1),R7     ; | | -twsti load
	mpyf    -1.,R7          ; | | twsti t->f (Opposite of f->t)
	call    cm4567          ; | | (67)=(45)*(67); (23) lost
	ldf     R6,R4           ; | | turnr update
	ldf     R7,R5           ; | | turni update
	nop     *AR1++          ; | | idx++
	ldi     IR0,AR2         ; | | 32 bit jump
	cmpi    AR2,AR1         ; | | idx < jump?
	blt     fwlp2           ; | ^
	nop     *AR0++(2)       ; | @twst update
	cmpi    1,IR0           ; | jump > 1?
	bgt     fwlp1           ; ^
fwdn    rets                    ; Done
;-------------------------------|
cm4567  mpyf3   R5,R7,R2        ; ii
	mpyf3   R5,R6,R3        ; ir
	mpyf    R4,R6           ; rr
	subf    R2,R6           ; r update
	mpyf    R4,R7           ; ri
	addf    R3,R7           ; i update
	rets                    ;
;-----------------------------------------
srss    absf    R2,R2           ; |r|
	absf    R3,R3           ; |i|
	cmpf    R2,R3           ; |i| > |r|?
	ble     iler            ; v
igtr                            ; |i| > |r|
	mpyf    0.4,R2          ; |
	mpyf    0.95,R3         ; |
	b       srsson          ; v
iler                            ; |i| <= |r|
	mpyf    0.95,R2         ; |
	mpyf    0.4,R3          ; v
srsson  addf    R3,R2           ; paths rejoin
	rets                    ;
;-----------------------------------------
rvfft   ldi     @atwide,AR0     ; Go thru twiddles in reverse order
	ldi     1,IR0           ; jump
rvlp1                           ; jump < n
	ldf     1.,R4           ; ^ turnr = 1.0
	ldf     0.,R5           ; | turni = 0.0
	ldi     0,AR1           ; | idx = 0
	nop     *--AR0(2)       ; | @twst update
rvlp2                           ; | idx < jump
	ldi     AR1,AR2         ; | ^
	ldi     AR1,AR3         ; | |
	addi    @axr,AR2        ; | | @xr[idx]
	addi    @axi,AR3        ; | | @xi[idx]
rvlp3                           ; | | iptr < n
	ldf     *+AR2(IR0),R6   ; | | ^ xr[jptr] load
     || ldf     *+AR3(IR0),R7   ; | | | xi[jptr] load
	call    cm4567          ; | | | (67)=(45)*(67); (23) lost
	ldf     *AR2,R2         ; | | | xr[iptr] load
     || ldf     *AR3,R3         ; | | | xi[iptr] load
	subf    R6,R2           ; | | |
	subf    R7,R3           ; | | |
	stf     R2,*++AR2(IR0)  ; | | | xr[jptr] update
     || stf     R3,*++AR3(IR0)  ; | | | xi[jptr] update
	addf3   *-AR2(IR0),R6,R2; | | |
	addf3   *-AR3(IR0),R7,R3; | | |
	stf     R2,*-AR2(IR0)   ; | | | xr[iptr] update
     || stf     R3,*-AR3(IR0)   ; | | | xi[iptr] update
	ldf     *AR2++(IR0),R2  ; | | | iptr updated for real parts
     || ldf     *AR3++(IR0),R3  ; | | | iptr updated for imag parts
	cmpi    @axi,AR2        ; | | | iptr < n? (For xi follows xr)
	blt     rvlp3           ; | | ^
	ldf     *AR0,R6         ; | | twstr
     || ldf     *+AR0(1),R7     ; | | twsti f->t (Opposite of t-f)
	call    cm4567          ; | | (67)=(45)*(67); (23) lost
	ldf     R6,R4           ; | | turnr update
	ldf     R7,R5           ; | | turni update
	nop     *AR1++          ; | | idx update
	ldi     IR0,AR2         ; | | 32 bit jump
	cmpi    AR2,AR1         ; | | idx < jump?
	blt     rvlp2           ; | ^
	lsh     1,IR0           ; | jump<<=1
	cmpi    n,IR0           ; | jump < n?
	blt     rvlp1           ; ^
rvdn    rets                    ; Done
;-------------------------------|
ccor    ldi     @atwids,AR0     ; @cos(180 deg/128)
	ldi     @axr,AR2        ; idx = 0
	ldi     @axi,AR3        ;
	ldf     0.,R0           ; Constant 0.0
	ldf     1.,R1           ; Constant 1.0
	ldf     *AR0,R4         ; cos(180 deg/128) delta phase real
     || ldf     *+AR0(1),R5     ; sin(180 deg/128) delta phase imag
	ldf     *--AR0(1),R7    ; sin(180 deg/256) initl phase imag
	ldf     *--AR0(1),R6    ; cos(180 deg/256) initl phase real
ccorlp1                         ; idx < n
	subf3   R6,R1,R2        ; ^ Raised cosine window
	mpyf    *AR2,R2         ; |
	stf     R2,*AR2++       ; | xr[idx] update
     || stf     R0,*AR3++       ; | xi[idx] zeroed
	call    cm4567          ; | (67)=(45)*(67); (23) lost
	cmpi    @axi,AR2        ; | idx < n?
	blt     ccorlp1         ; ^
skpwin       
	call    fwfft           ; FORWARD FFT W/O BIT REVERSAL
	ldi     @axr,AR2        ; @xr[idx=0]
	ldi     @axi,AR3        ; @xi[0]
	ldf     0.,R0           ; Constant 0.0
	stf     R0,*AR2++       ; Zero DC real
     || stf     R0,*AR3++       ; Zero DC imag
	stf     R0,*AR2++       ;
     || stf     R0,*AR3++       ;
ccorlp2                         ; idx < n
	ldf     *AR2,R2         ; ^
     || ldf     *AR3,R3         ; |
	call    srss            ; | Approx sqrt sum sqs
	stf     R2,*AR2++       ; | Real part, positive freq
     || stf     R0,*AR3++       ; |
	stf     R0,*AR2++       ; |
     || stf     R0,*AR3++       ; |
	cmpi    @axi,AR2        ; | idx < n?
	blt     ccorlp2         ; ^
	call    rvfft           ; REV FFT W/O BIT REVERSAL OR /N
ccordn  rets                    ;
;-------------------------------|
;       .include "CCSRCH.ASM"
;  CCSRCH.ASM  Complex Correlation Search, TMS320C3x assembly language
;----------------------------------------------------------------------
accssr  .word   xr+13           ; @cmplx corr search start real @ 250 Hz
accssi  .word   xi+13           ; @cmplx corr search start imag @ 250 Hz
accser  .word   xr+64           ; @cmplx corr search end   real @ 50 Hz
curpow  .float  0.              ; current power (histogram increment)
tau     .float  100.            ; floating point pitch period, ccor units
arctan  .float  0.              ; Result of atan2 computation
;-------------------------------|
ccsrch  ldi     @accssr,AR0     ; @search start real
	ldi     @accssi,AR1     ; @search start imag
	ldi     AR0,AR2         ; @selected real
	ldi     AR1,AR3         ; @selected imag
	ldf     0.,R5           ; Biggest mag*mag so far
ccslp                           ; @real < @search end real
	ldf     *AR0++,R0       ; ^ real
     || ldf     *AR1++,R1       ; | imag
	mpyf    R0,R0           ; | real*real
	mpyf    R1,R1           ; | imag*imag
	addf    R1,R0           ; | mag*mag
	cmpf    R5,R0           ; | mag*mag <= Biggest so far?
	ble     ccson           ; ^ v
	ldi     AR0,AR2         ; | | No.  Save address of real
	ldi     AR1,AR3         ; | |      Save address of imag
	ldf     R0,R5           ; | |      Save mag*mag as biggest so far
ccson                           ; | *
	cmpi    @accser,AR0     ; | @real < @search end real?
	blt     ccslp           ; ^
;-------------------------------|
	subi    1,AR2           ; Because was *AR0++
	subi    1,AR3           ; Because was *AR1++
	ldf     *-AR2(1),R2     ; real[-1]
     || ldf     *-AR3(1),R3     ; imag[-1]
	mpyf    R2,R2           ; real*real[-1]
	mpyf    R3,R3           ; imag*imag[-1]
	addf3   R2,R3,R4        ; mag*mag[-1]
	ldf     *+AR2(1),R2     ; real[1]
     || ldf     *+AR3(1),R3     ; imag[1]   
	mpyf    R2,R2           ; real*real[1]
	mpyf    R3,R3           ; imag*imag[1]
	addf3   R2,R3,R6        ; mag*mag[1]
;-------------------------------|
	ldf     0.,R7           ; delta default = 0.
	cmpf    R4,R5           ;
	blt     pkxon           ; v Don't interp if mid not biggest
	cmpf    R6,R5           ; |
	blt     pkxon           ; v Don't interp if mid not biggest
	addf3   R5,R5,R0        ; | (y+y)[0]
	subf    R4,R0           ; | (y+y)[0]-y[-1]
	subf    R6,R0           ; | den = (y+y)[0]-y[-1]-y[1] <= 0?
	ble     pkxon           ; v
	ldi     7,RC            ; | No;  set rsqrt repeat count
	call    rsqrt           ; | R1=1/sqrt(R0), R2=1/R0;  R0, RC lost
	subf3   R6,R4,R7        ; | y[1]-y[-1]
	mpyf    0.5,R7          ; | numerator = (y[1]-y[-1])/2
	mpyf    R2,R7           ; v delta = num/den
pkxon                           ; *
	ldi     AR2,R0          ;
	subi    @axr,R0         ; Integer tau
	float   R0,R0           ; floating point integer-valued tau
	addf    R7,R0           ; tau
	stf     R0,@tau         ; tau
	call    intrp           ; R2=interp(R456=mag*mag's)@R7;  R01 lost
	stf     R2,@curpow      ; current power;  (histogram increment)
	ldi     AR3,AR0         ; @i[0]
	call    loadit          ; R2 = interp(i's)@R7;  R01 lost
	ldf     R2,R3           ; R3 = interp(i)
	ldi     AR2,AR0         ; @r[0]
	call loadit             ; R2 = interp(r's)@R7;  R01 lost
				; (R23)=(ri)[R7=delta x]
	call    atan2           ; R0=arctan;  AR0, RC, all R's but 5 lost
	stf     R0,@arctan      ;
	rets                    ;
;--------------------------------------------------------------
loadit                          ; > Entry for r or i interpolation
	; Entry to intrp which loads values to be interpolated
	ldf     *-AR0(1),R4     ; y[-1]
     || ldf     *AR0,R5         ; y[0]
	ldf     *+AR0(1),R6     ; y[1]
intrp                           ; > Entry for mag*mag interpolation
	; Call with R4,5,6 = y[-1,0,1], R7=delta x
	; Returns interp y in R2; R0,1 lost
	subf3   R4,R6,R1        ; 2*b = y[1]-y[-1]
	addf3   R4,R6,R0        ; y[-1]+y[1]
	subf    R5,R0           ; y[-1]+y[1]-y[0]
	subf    R5,R0           ; 2*a = y[-1]+y[1]-y[0]-y[0]
	mpyf3   R0,R7,R2        ; 2*a*x
	addf    R1,R2           ; 2*a*x+2*b
	mpyf    0.5,R2          ; a*x+b
	mpyf    R7,R2           ; a*x*x+b*x
	addf    R5,R2           ; interpolated y = a*x*x+b*x+y[0]
	rets                    ; <
;-------------------------------|
aattbl  .word   attbl           ; address of arctan tables
;-------------------------------|
atan2                           ; > 4-quadrant arctan accurate to 0.00005
	; Entry R23 = ri. 
	; Exit -.5 < (R0=arctan) <= 0.5
	; AR0, RC, and all R's but R5 lost.  Calls rsqrt.
	ldf     R2,R4           ; r
	absf    R2,R6           ; magr
	absf    R3,R7           ; magi
	ldf     0.,R2           ; default ratio
	ldi     7,RC            ; rsqrt repeat count
	cmpf    R6,R7           ; magi < magr?
	blt     miltmr          ; v
	cmpf    0.,R7           ; | No.  magi <= 0.?
	ble     migemro         ; | v
	ldf     R7,R0           ; | | Not both zero.  magi
	call    rsqrt           ; | | R2 = 1/magi;  R01, RC lost
	mpyf    R6,R2           ; | | ratio = magr/magi
migemro                         ; | *
	b       atan2on         ; v
	;-----------------------;
miltmr                          ; * magi < magr (so not both zero)
	ldf     R6,R0           ; | magr
	call    rsqrt           ; | R2 = 1/magr;  R01, RC lost
	mpyf    R7,R2           ; v ratio = magi/magr
atan2on                         ; *
	mpyf    10.,R2          ; tenrat
	ldf     R2,R0           ; tenrat
	addf    0.5,R0          ; round
	fix     R0,R0           ; round to integer
	ldi     R0,IR0          ; index to atan tables
	float   R0,R0           ; floating point integer-valued tenrat
	subrf   R2,R0           ; x
	ldi     @aattbl,AR0     ; @atb[0]
	mpyf    *AR0(IR0),R0    ; atb*x
	addi    11,AR0          ; @atca[0]
	addf    *AR0(IR0),R0    ; first octant arctan = atb*x+atca
	cmpf    R6,R7           ; magi < magr?
	blt     atan2o2         ; v
	subrf   0.25,R0         ; | No. Second octant.
atan2o2                         ; *                                
	cmpf    0.,R4           ; r >= 0?              atan=0.25  atan=
	bge     atan2o3         ; v                        ^I     0.125
	subrf   0.5,R0          ; | No. Quadr 2.           |Oct2_/
atan2o3                         ; *                 Quad2  |  Quad1
	cmpf    0.,R3           ; i >= 0?       atan       |_/  Oct1 atan
	retsge                  ; < if yes      =0.5-------0-------> =0.0
	mpyf    -1.,R0          ; | Quadr 3,4              |        R
	rets                    ; <                 Quad3  |  Quad4
;---------------------------------------------|            |       
attbl   .float  0.015863, 0.015708, 0.015262  ; atb        |
	.float  0.014572, 0.013702, 0.012725  ;        atan=-.25
	.float  0.011704, 0.010689, 0.009716  ;
	.float  0.008806, 0.007971            ;
;---------------------------------------------|
atca    .float  0.,       0.015851, 0.031392  ; atca  
	.float  0.046354, 0.060520, 0.073750  ;       
	.float  0.085968, 0.097158, 0.107349  ;
	.float  0.116594, 0.124967            ;
;---------------------------------------------|
;       .include "HISTGR.ASM"
;  HISTGR.ASM  Histogram management software, TMS320C3x
;-----------------------------------------------------
concons .float  9765.625/4./450.; 450 * 2 Hz total histr range
;-----------------------------------------------------
inchist                         ; Increment Histogram
	ldf     @tau,R0         ; Tau in half-sampl-rate samples
	ldi     7,RC            ; For rsqrt
	call    rsqrt           ; R2 = 1 / tau
	mpyf    @fnbins,R2      ; nbins / tau
	mpyf    @concons,R2     ; Conversion constant
	stf     R2,@hpitch      ; hpitch = concons * nbins / tau
	mpyf    @arctan,R2      ;
	ldf     @fnbins,R1      ;
	mpyf    0.125,R1        ;
	addf    R1,R2           ; hshift = nbins/8 + arctan * hpitch
	stf     R2,@hshift      ;
	ldf     @hshift,R3      ; One possible bin index
inclp1                          ; hist index >= 0.
	call    incbin          ; ^ increment a bin
	subf    @hpitch,R3      ; | go to next lower bin
	bge     inclp1          ; ^ hist index >= 0?
	;-----------------------|
	ldf     @hshift,R3      ; One possible bin index
inclp2                          ; hist index < num bins
	addf    @hpitch,R3      ; ^ go to next higher bin
	cmpf    @fnbins,R3      ; | hist index >= numb bins?
	bge     inchdn          ; v If yes, done incrementing
	call    incbin          ; | No.  Increment a bin
	b       inclp2          ; ^
inchdn  rets                    ; done incrementing
;-------------------------------;
hshift  .float  0.              ; One possible bin index, fl pt
hpitch  .float  0.              ; Pitch interval in bin widths, fl pt
fnbins  .float  endbins-bins    ; Number of bins, fl pt
alwbin  .word   bins            ; address of first bin, int
;-------------------------------|
incbin                          ; > Subroutine to increment a bin
	ldf     R3,R4           ; floating point index to bin
	fix     R4,R4           ; integer index to bin
	addi    @alwbin,R4      ; address of bin
	ldi     R4,AR0          ;
	ldf     *AR0,R4         ; content of bin
	addf    @curpow,R4      ; content incremented by current power
	stf     R4,*AR0         ; bin updated
	rets                    ; <
;-------------------------------|-----------------------------------
srchist                         ; Search Histogram
	ldi     @alwbin,AR0     ; Low index lidx
	ldi     AR0,AR1         ; High index hidx
	ldi     AR0,AR2         ; Min width low index minlow
	ldi     @abinend,AR3    ; Min width high index
	ldf     @thresh,R0      ; Window-sum threshold
	ldf     -1.,R4          ; Max sum so far, init imposs value
	ldf     *AR1++,R1       ; Window sum
shlp1                           ; *
	subi3   AR2,AR3,R3      ; ^ Min width so far
shlp2                           ; | *
shlp3                           ; | ^ *
	cmpf    R0,R1           ; | | | sum >= thresh?
	bge     shon1           ; | | v
	cmpi    @abinend,AR1    ; | | | No.  hidx >= nbins?
	bge     shdone          ; v If yes, done
	addf    *AR1++,R1       ; | | | No.  Increase sum
	b       shlp3           ; | | ^
;-------------------------------| | | |
shon1                           ; | | * sum >= thresh
shlp4                           ; | | * sum >= thresh
	ldf     R1,R5           ; | | | Save sum before reducing
	subf    *AR0++,R1       ; | | | Reduce sum
	ble     shon2           ; | | v Precaution
	cmpf    R0,R1           ; | | | sum >= thresh?
	bge     shlp4           ; | | ^
	;-----------------------| | | |
shon2                           ; | | * sum < thresh, after being >=.
	subi3   AR0,AR1,R2      ; | | Window width
	cmpi    R3,R2           ; | | width > min width so far?
	bgt     shlp2           ; | ^ If so, go look further
	blt     shon3           ; | v If widths not equal go save values
	cmpf    R5,R4           ; | | Widths equal; max sum >= new sum?
	bge     shlp2           ; | ^ If so go look further
shon3                           ; | *
	ldi     AR0,AR2         ; | Save lidx
	ldi     AR1,AR3         ; | Save hidx
	ldf     R5,R4           ; | Save window sum
	b       shlp1           ; ^
;-------------------------------|----------------------------
abinend .word   endbins         ; First address after histogram bins
thresh  .float  0.              ; Threshold for window sum
;-------------------------------|-----------------------------
shdone  rets                    ; * Done searching histogram
;--------------------------------------------------------------
hflim  .float  450.            ; 0.5 * Hist freq range in Hz
;--------------------------------------------------------------
calcsft                         ; >
	subi3   AR2,AR3,R2      ; 0==1 bin, 1==2 bins, etc
	sti     R2,@minwid      ; For performance monitoring
	cmpi    AR5,R2          ; Less than (settable) bins?
	retsge                  ; < If no, use old freq shift
clson                           ; Yes.  Calc freq shift
	ldi     AR2,R1          ; Addr just past window low-end
	subi    @alwbin,R1      ; Index just past wind low-end index
	lsh     1,R1            ; 2 * low index + 2
	subi    1,R1            ; 2 * low index + 1
	addi    R2,R1           ; Low index + High index + 1
	float   R1,R1           ;
	mpyf    @rnbins,R1      ; (Low + high index + 1) / nbins
	subrf   0.25,R1          ; -(Low + high + 1 - nbins/4) / nbins
	mpyf    @hflim,R1       ; Float freq correc Hz
	fix     R1,R1           ; Freq correc Hz
	ldi     R1,AR7          ;
	rets                    ;
;-------------------------------|-------------------------------
rnbins  .float  1.0 / (endbins-bins)      ; 1./nbins
minwid  .word   1024            ; Num bins -1 in mid width interval
;------------------------------------------------------------------
;-------------------------------------------------------------------
DAC2      push  ST              ; DAC Interrupt service routine
	  push  R0              ;
	  pushf R0              ;
	  push  R1              ;
	  pushf R1              ;
	  push  R2              ;
	  pushf R2              ;
	  push  AR0             ;
	  push  AR1             ;
	  push  IR0             ;
	  push  BK              ;
	  push  RC              ;
	  ldf   @NwA_imag,R0    ;
	  cmpf  @ANG_imag,R0    ; Change in freq to shift?
	  bz    dac2on          ; v If no, skip parameter update
	  stf   R0,@ANG_imag    ; |
	  stf   R0,@CX_imag     ; | Refresh complex exponential
	  ldf   @NwA_real,R0    ; |
	  stf   R0,@ANG_real    ; |
	  stf   R0,@CX_real     ; | Refresh complex exponential
	  ldi   @NwDCterm,R0    ; |
	  sti   R0,@DCterm      ; |
dac2on                          ; *
	  
	  ldi   @dattrig,R1     ; Test for FFT data trigger
	  bz    dac2on2         ; v
	  ldi   @datrdy,R1      ; | Test for FFT data ready
	  bnz   dac2on2         ; v
	  ldi   @eltim,R1       ; | Test for time odd
	  and   1,R1            ; |
	  bz    dac2on2         ; v
	  ldi   @HILB_last,AR1  ; |
	  ldi   @adcfl,AR0      ; | Addr of decimation lowpass filter
	  ldi   @BFSIZE,BK      ; |
	  nop   *AR1--(1)%      ; | To point to newest

DCFIR     mpyf3 *AR0++,*AR1--(1)%,R0 ; | Go thru buf newest back
	  ldf   0.0,R2               ; |
	  ldi   8,RC            ; | Length 21 symmetric imp resp
	  rptb  DCFIR2               ; | *
	  mpyf3 *AR0++,*AR1--(1)%,R0 ; | |
DCFIR2 || addf3 R0,R2,R2             ; | *
	  ldi 10,RC             ; | Length 21 symmetric imp resp
	  rptb  DCFIR3               ; | *
	  mpyf3 *AR0--,*AR1--(1)%,R0 ; | |
DCFIR3 || addf3 R0,R2,R2             ; | *
	  addf  R2,R0           ; |
decstor   ldi   @xrp,AR0        ; |
	  stf   R0,*AR0++       ; |
	  sti   AR0,@xrp        ; |
	  cmpi  @axi,AR0        ; | Assumes i's immed follow r's
	  blt   dac2on2         ; v
	  ldi   1,R1            ; |
	  sti   R1,@datrdy      ; | Data now ready
dac2on2                         ; *

	  ldi   @BFSIZE,BK      ;  Size of Hilbert filter input buffer
	  ldi   2,IR0           ;  Every second filter tap is zero
	  ldi   @HILB_last,AR1  ;  
	  nop   *AR1--%         ;  points AR1 to newest
	  ldi   @HILB_coefx,AR0 ;
FIR       
	  mpyf3 *AR0++,*AR1--(IR0)%,R0 ; (2) because every 2nd hilb tap=0
	  ldf   0.0,R2
	  ldi   5,RC     ;  Hardwire Hilb transform w 31 taps, 16 nonzero
	  rptb  FIR2                   ; *
	  mpyf3 *AR0++,*AR1--(IR0)%,R0 ; | Every 2nd hilb tap=0
FIR2  ||  addf3 R0,R2,R2               ; ^
	  mpyf3 *AR0,*AR1--%,R0 ; Set for midpoint of filt, get sample
      ||  addf3 R0,R2,R2

	  ldf   *AR1--%,R1
	  stf   R1,@MIDSAMP

;  Now go backward thru Hilb filter taps, subtracting

	  mpyf3 *AR0--,*AR1--(IR0)%,R0 ; Every 2nd hilb tap=0
      ||  addf3 R0,R2,R2               ; Add previous product
	  ldi   6,RC                   ;
	  rptb  FIR3                   ; *
	  mpyf3 *AR0--,*AR1--(IR0)%,R0 ; | Every 2nd hilb tap=0
FIR3  ||  subf3 R0,R2,R2               ; ^
	  subf  R2,R0                  ;


;  Update complex exponential

	  ldf   @ANG_real,R2
	  mpyf  @CX_real,R2
	  ldf   @ANG_imag,R1
	  mpyf  @CX_imag,R1
	  subf  R1,R2
	  ldf   @ANG_imag,R1
	  mpyf  @CX_real,R1
	  stf   R2,@CX_real
	  ldf   @ANG_real,R2
	  mpyf  @CX_imag,R2
	  addf  R1,R2
	  stf   R2,@CX_imag

	  ldf   @MIDSAMP,R2
	  mpyf  @CX_real,R2
	  mpyf  @CX_imag,R0
	  subf  R2,R0           ;  + angle => + frequency shift

outR0     fix   R0,R0           ;
	  addi  @DCterm,R0      ;
	  andn  3,R0            ;
	  sti   R0,@S0_xdata    ; Output the new DAC value
	  ldi   @eltim,R1       ;
	  addi  1,R1            ; Increment elapsed time
	  sti   R1,@eltim       ;
	  pop   RC              ;
	  pop   BK              ;
	  pop   IR0             ;
	  pop   AR1             ;
	  pop   AR0             ;
	  popf  R2              ;
	  pop   R2              ;
	  popf  R1              ;
	  pop   R1              ;
	  popf  R0              ;
	  pop   R0              ;
	  pop   ST              ;
	  reti                  ;
;-------------------------------
holdi   .word   0               ; Integer memory for pre-emphasis
ADC2      push  ST              ;
	  push  R3              ;
	  pushf R3              ;
	  push  AR0             ;
	  ldi   @S0_rdata,R3    ;

	  lsh   16,R3
	  ash   -16,R3

****          ldi   @holdi,AR0      ; Pre-emphasis
****          sti   R3,@holdi       ; Bring out higher harmonics
****          subi  AR0,R3

	  ldi   @HILB_last,AR0
	  float R3,R3
	  stf   R3,*AR0++

	  cmpi  @HILB_end,AR0
	  ldige @HILB_first,AR0
	  sti   AR0,@HILB_last

	  pop   AR0
	  popf  R3              ;
	  pop   R3              ;
	  pop   ST              ;
	  reti                  ;
;*****************************************************;
; The startup stub is used during initialization only ;
; and can be safely overwritten by the stack or data  ;
;*****************************************************;
stack   .word   $                                     ;
;*****************************************************;
	  .entry   ST_STUB      ; Debugger starts here
ST_STUB   ldp   T0_ctrl         ; Use kernel data page and stack
	  ldi   @stack,SP
	  ldi   0,R0            ; Halt TIM0 & TIM1
	  sti   R0,@T0_ctrl     ;
	  sti   R0,@T0_count    ; Set counts to 0
	  ldi   1,R0            ; Set periods to 1
	  sti   R0,@T0_prd      ;
	  ldi   0x2C1,R0        ; Restart both timers
	  sti   R0,@T0_ctrl     ;
	  ;---------------------
	  ldi   @S0_xctrl_val,R0;
	  sti   R0,@S0_xctrl    ; transmit control
	  ldi   @S0_rctrl_val,R0;
	  sti   R0,@S0_rctrl    ; receive control
	  ldi   0,R0            ;
	  sti   R0,@S0_xdata    ; DXR data value
	  ldi   @S0_gctrl_val,R0; Setup serial port
	  sti   R0,@S0_gctrl    ; global control
;======================================================;
; This section of code initializes the AIC             ;
;======================================================;
AIC_INIT  LDI   0x10,IE         ; Enable only XINT interrupt
	  andn  0x34,IF         ;
	  ldi   0,R0            ;
	  sti   R0,@S0_xdata    ;
	  RPTS  0x040           ;
	  LDI   2,IOF           ; XF0=0 resets AIC
	  rpts  0x40            ;
	  LDI   6,IOF           ; XF0=1 runs AIC
	  ;---------------------
	  ldi   @C_REG,R0       ; Setup control register
	  call  prog_AIC        ;
	  ldi   0xfffc  ,R0     ; Program the AIC to be real slow
	  call  prog_AIC        ;
	  ldi   0xfffc|2,R0     ;
	  call  prog_AIC        ;
	  ldi   @B_REG,R0       ; Bump up the Fs to final rate
	  call  prog_AIC        ; (smallest divisor should be last)
	  ldi   @A_REG,R0       ;
	  call  prog_AIC        ;
	  b     main            ; the DRR before going to the main loop
;-------------------------------
prog_AIC  ldi   @S0_xdata,R1    ; Use original DXR data during 2 ndy
	  sti   R1,@S0_xdata    ;
	  idle
	  ldi   @S0_xdata,R1    ; Use original DXR data during 2 ndy
	  or    3,R1            ; Request 2 ndy XMIT
	  sti   R1,@S0_xdata    ;
	  idle                  ;
	  sti   R0,@S0_xdata    ; Send register value
	  idle                  ;
	  andn  3,R1            ;
	  sti   R1,@S0_xdata    ; Leave with original safe value in DXR
	  ;---------------------
	  ldi   @S0_rdata,R0    ; Fix the receiver underrun by reading
	  rets                  ;
****stack     .word   $             ; Put stack here
;****************************************************;
; Install the XINT/RINT ISR handler directly into    ;
; the vector RAM location it will be used for        ;
;****************************************************;
	  .start   "SP0VECTS",0x809FC5
	  .sect    "SP0VECTS"
	  B        DAC2         ; XINT0
	  B        ADC2         ; RINT0
