/*  HILB.C  */
#define BUFLEN 1054

void hilb(int remember, int n, float in[], float out[])
/* remember==0 is signal to zero internal memory before proceeding
 * n is number of points in and out.  Need 0<n<=BUFLEN-30
 * in is input
 * out is output, delayed 15 points
 */
{
   static float buf[BUFLEN];  /* 30 pts old input then n pts new  */
   float tap[8] = {0.0205, 0.0213, 0.0326, 0.0488,
                   0.0730, 0.1140, 0.2040, 0.6338};
   /* 31-tap filter, every second tap zero, antisymmetric
    * gain 0.976 to 1.024 in 0.03 to 0.47 sample rate
    */
    int ipt, idx;
    float sum;

   if(remember==0)
   {
      for(idx=0;idx<30;idx++)
      {
         buf[idx]=0.;
      }
   }
   for(idx=0;idx<n && idx<BUFLEN-30;idx++)
   {  /*  add new input data to buffer  */
      buf[idx+30]=in[idx];
   }
   for(idx=0;idx<BUFLEN-30 && idx<n;idx++)
   {  /*  form one point of output  */
      sum=0.;
      for(ipt=0;ipt<8;ipt++)
      {  /*  add effects of two taps with same magnitude  */
         sum+=(buf[idx+16+2*ipt] -
               buf[idx+14-2*ipt])*tap[7-ipt];
      }
      out[idx]=sum;
   }
   for(idx=0;idx<30 && idx+n<BUFLEN;idx++)
   {  /*  save last 30 points of input  */
      buf[idx]=buf[idx+n];
   }
}
