/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;

import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.graphics.Canvas;
import android.os.Handler;

public class NS3_App extends Application{
	
    // Debugging
    private static final String TAG = "NS3_App";
    private static final boolean D = false;// false true

    // Message types sent from the BluetoothChatService Handler
    protected static final int MESSAGE_STATE_CHANGE = 1;
    protected static final int MESSAGE_READ = 2;
    protected static final int MESSAGE_WRITE = 3;
    protected static final int MESSAGE_DEVICE_NAME = 4;
    protected static final int MESSAGE_TOAST = 5;

    // Key names received from the BluetoothChatService Handler
    protected static final String DEVICE_NAME = "device_name";
    protected static final String TOAST = "toast";
    protected static String mConnectedDeviceName="";
    
    protected static final int REQUEST_CONNECT_DEVICE_SECURE = 1;
    protected static final int REQUEST_CONNECT_DEVICE_INSECURE = 2;    
    protected static final int REQUEST_ENABLE_BT = 3;
    protected static final int PHASE_OFFSET_UPDATE_GEN_A = 4;
    protected static final int PHASE_OFFSET_UPDATE_GEN_B = 5;
    protected static final int OUTPUT_LEVEL_UPDATE_GEN_A = 6;
    protected static final int OUTPUT_LEVEL_UPDATE_GEN_B = 7;
    protected static final int AM_MOD_INDEX_UPDATE_GEN_A = 8;
    protected static final int AM_MOD_INDEX_UPDATE_GEN_B = 9;
    protected static final int FM_DEV_UPDATE_GEN_A = 10;
    protected static final int FM_DEV_UPDATE_GEN_B = 11;
    protected static final int MOD_FREQ_HZ_UPDATE = 12;
    protected static final int SWEEP_GEN_RESULTS= 13;
    protected static final int SWEEP_GEN_NEW_SETUP= 14;
    protected static final int SWEEP_GEN_SET_CNTR_FREQ_HZ=15;

    protected static String sMeasuredRFLevel_dBm_Str="pending";
    protected static Canvas sCanvas;
    protected static int sCanvasWidth=1200;
    protected static int sg_X_Center=600; 
    protected static int sCanvasHeight=644;
    protected static int sg_Y_TopBorder=100;
    protected static int sg_Y_BtmBorder=750;
    protected static int sg_X_LeftBorder=100;
    protected static int sg_X_RightBorder=1103;
    
	protected static int sg_SweepCenterFreqHz=45250000;
	protected static int sg_SweepSpanFreqHz=1000000;
	protected static int sg_SweepStartFreqHz=50000000;
	protected static int sg_SweepStopFreqHz=100000000;
	protected static int sg_StepsPerSweep=250;
	protected static int sg_HzPerDiv_Int=100000;
	protected static int sg_HzPerStep_Int=200000;
	protected static int sg_2dB_DivRefLvl_Int=-10;
	protected static int sg_Scale_dB_Div_Int=10;
	protected static int sg_SweepTime_mS_Int=10;
	protected static int sg_Yaxis_RefLevel_dBm_Int= 20;
	protected static int sg_Yaxis_DynamicRange_dB_Int= 100;
	
	protected static float sg_stepSizeHz_Flt=1;
	protected static float sg_HzPerPixel_Flt=1;
	protected static float sg_dB_PerPixel_Flt=1;	

	protected static String sg_HzPerDiv_Int_Str="null";

	protected static String sg_SweepCurrentFreqHz_Str="pending";
	protected static String sg_SweepCenterFreqHz_Str="null";
	protected static String sg_SweepStartFreqHz_Str="null";
	protected static String sg_SweepStopFreqHz_Str="null";
	protected static String sg_SweepSpanFreqHz_Str="null";
	
    protected static boolean sg_SweepActivated=false;
    protected static boolean sg_SweepStart=false;
    protected static boolean sg_SweepStartNew=true;
    protected static boolean sg_DrawGrid=true;
    protected static boolean sg_refreshScreen=false;
    protected static boolean sg_NormalizeMode_b = false; 
    protected static boolean sg_10dB_Div_Yaxis_b = true;
    

    
    public static Handler spectrumDisplayHandler;
    public static Handler nimbleSigSweepGenMainHandler;
    public static BluetoothChatService mChatService = null;
    // Local Bluetooth adapter
    protected BluetoothAdapter mBluetoothAdapter = null;
    // String buffer for outgoing messages
    protected StringBuffer mOutStringBuffer;
    protected int g_BT_RXD_BfrPtr = 0;//sync relationship with BluetoothChatService
//    private static NS3_App sInstance;
    protected static boolean gs_SweepGenMode_b;
    protected static String testStr="";
    private static NS3_App sInstance;

    public static NS3_App getInstance() {
        return sInstance;
      }
    public Handler getTarget() {
        return spectrumDisplayHandler;
    }
    @Override    
	public void onCreate(){
		super.onCreate();
		  sInstance = this;
	      sInstance.initializeInstance();
      	      
	      // Get local Bluetooth adapter
        mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();    
    }
    
/*    protected void initNS_Singleton()
    {
    	 // Initialize the instance of MySingleton
    	NS_Singleton.initInstance();
    }
*/
    public void customAppMethod()
    {
     // Custom application method
    }  
      
//    public static BluetoothChatService getConnectedThread() {
//        return mChatService;
//    }

//    public void setConnectedThread(BluetoothChatService mBluetoothConnectedThread) {
//        this.mChatService = mBluetoothConnectedThread;
//    }
    protected void initializeInstance() {
        // do all your initialization here
//        sessionHandler = new SessionHandler( 
//            this.getSharedPreferences( "PREFS_PRIVATE", Context.MODE_PRIVATE ) );
    }

    
}
