/*
 * Copyright (C) 2013 Thomas M. Alldread
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package va7ta.app.nimblesigsweepgen;

import va7ta.app.nimblesigsweepgen.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;


public class SetGen_B_AM_ModIndex extends Activity{


			private static final String TAG = "NimbleSig.SetAM_modIndexB";//ID for debug progress error message
		    private static final boolean D = true;
		    
		    
		    private String currentModAMIdxB_Str="0";
		    private String newModAMIdxB="0";
		    private String newModAMIdxB_Value="0";
		    private String newModAMIdxB_mDeg="0";
		    
			private Button mModAMIdxB_SetButton;
			private SeekBar mCourseAdjSeekBar;
			private SeekBar mFineAdjSeekBar;
			private SeekBar mExtraFineAdjSeekBar;
			
			private int start_positionCrs=0; 
			private int amModIdxInt=0; 
		    private int milliamModIdx;
			private int start_positionFine=0; 
			private int amModIdx=0; 
			
		    private float temp=0;
			private float startCrs=0; 
			private float endCrs=0; 
			private float start_posCrs=0; 
			private float startFine=0; 
			private float endFine=0; 
			private float start_posFine=0; 
			private float lastFineCorrection=0;
			private float fineCorrection=0;

			private boolean fineBarAutoCentre=false;
			private boolean courseBarAutoAdj=false;
			
			
			@Override
			public void onCreate(Bundle icicle) {
		    super.onCreate(icicle);
		    	if(D) Log.e(TAG, "+++ SET GEN B AM MOD INDEX +++");

		        Intent currentValIntent = getIntent();
		        if(currentValIntent.hasExtra("valAM_ModIdxB")){
		            currentModAMIdxB_Str = currentValIntent.getStringExtra("valAM_ModIdxB");
		        }
		    	setContentView(R.layout.activity_nimble_sig_rfgen_set_am_mod_index);// Paint the adjust screen

		        TextView modAMIdxBValStr =(TextView) findViewById(R.id.newValue);
		        modAMIdxBValStr.setText(currentModAMIdxB_Str);            
		    	TextView modAMIdxBdjTitle = (TextView) findViewById(R.id.parameterAdjustTitle); 
		    	modAMIdxBdjTitle.setText("VFO 'A' AM Mod Index - %");
		    	
		    	//Course SeekBar range is 0-100 units
		    	//Initialize Bar settings
		        amModIdx=(Integer.valueOf(currentModAMIdxB_Str)); 
		        start_posCrs =amModIdx;
		        start_positionCrs=(int) (start_posCrs); 
		        mCourseAdjSeekBar=(SeekBar) findViewById(R.id.courseAdj_Bar); 
		        mCourseAdjSeekBar.setProgress(start_positionCrs); 
		        mFineAdjSeekBar=(SeekBar) findViewById(R.id.fineAdj_Bar); 
		        mFineAdjSeekBar.setProgress(5); 

		        
		        mCourseAdjSeekBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

		            @Override 
		            public void onStopTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 
		/*
		            	if (amModIdx >= 0){
		            		milliamModIdx *= (int)1000;
		            	}
		            	if (amModIdx < 0){
		            		milliamModIdx = (int)(360-amModIdx)*1000;
		            	}
		            	
		                newModAMIdxB_mDeg = String.valueOf(milliamModIdx);
//		            	sendMessage("pa"+newModAMIdxB_mDeg);
		*/
		            	lastFineCorrection = 0;
		                mFineAdjSeekBar.setProgress(5);
		            } 

		            @Override 
		            public void onStartTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 

		            } 

		            @Override 
		            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
		                // TODO Auto-generated method stub 
		            	if(!courseBarAutoAdj){
			            	// To convert it as amModIdx value 
		            		amModIdx=progress;
			                newModAMIdxB = String.valueOf(progress);			           
			                upDateModAMIdxBVal(progress);
		            	}else courseBarAutoAdj=false;
		            } 
		        }); 
		 
		        mFineAdjSeekBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() { 

		            @Override 
		            public void onStopTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 
		                // To convert it as amModIdx value 
		                courseBarAutoAdj=true;
		    	        start_posCrs =amModIdx;
		    	        start_positionCrs=(int) (start_posCrs);	                
		                mCourseAdjSeekBar.setProgress(start_positionCrs);
		                fineBarAutoCentre=true;
		                mFineAdjSeekBar.setProgress(5);
		                lastFineCorrection = 0;	                
		            } 

		            @Override 
		            public void onStartTrackingTouch(SeekBar seekBar) { 
		                // TODO Auto-generated method stub 

		            } 

		            @Override 
		            public void onProgressChanged(SeekBar seekBar, int progress,boolean fromUser) { 
		                // TODO Auto-generated method stub 
		            	if(!fineBarAutoCentre){
			                fineCorrection=(progress-5);		                
			                amModIdx += (fineCorrection-lastFineCorrection);            
			                lastFineCorrection = fineCorrection;
			                newModAMIdxB = String.valueOf(amModIdx);
			                upDateModAMIdxBVal(amModIdx);
		            	}
		                else fineBarAutoCentre = false;
		            } 
		        }); 
		 
		    }//onCreate 
			
			
		    public void upDateModAMIdxBVal(int val) {
		        TextView ModAMIdxB_ValLabel = (TextView) findViewById(R.id.newValue);
		        ModAMIdxB_ValLabel.setText(String.valueOf(val));
		    }

		    @Override
		    public synchronized void onResume() {
		        super.onResume();
		    	if(D) Log.e(TAG, "+++ ON RESUME +++");
		       

		        //VFO A Level SET button with a listener that for click events
//		        mModAMIdxB_SetButton = (Button) findViewById(R.id.updateLevelBtn);
		        mModAMIdxB_SetButton = (Button) findViewById(R.id.updateModIndexBtn);
		        mModAMIdxB_SetButton.setOnClickListener(new OnClickListener() {
		        	public void onClick(View v) {
		                TextView ModAMIdxB_Value=(TextView) findViewById(R.id.newValue);
		                newModAMIdxB_Value = ModAMIdxB_Value.getText().toString();
		            	Intent newModAMIdxB_Val=new Intent(getApplicationContext(), NimbleSigSweepGenMain.class);
		            	newModAMIdxB_Val.putExtra("valModAMIdxB",newModAMIdxB_Value);
		        		finish ();
		        	}
		        });
		        
		    }//onResume
		    
		    @Override
		    public void finish() {
		      // Prepare data intent 
		      Intent newModAMIdxB_ValIntent = new Intent();
		      newModAMIdxB_ValIntent.putExtra("valModAMIdxB", newModAMIdxB_Value);
		      // Activity finished ok, return the data
		      setResult(RESULT_OK, newModAMIdxB_ValIntent);
		      super.finish();
		    } 
		   
		    @Override
		    public synchronized void onPause() {
		        super.onPause();
//			        if(D) Log.e(TAG, "- ON PAUSE -");
		    }

		    @Override
		    public void onStop() {
		        super.onStop();
//			        if(D) Log.e(TAG, "-- ON STOP --");
		    }

		    @Override
		    public void onDestroy() {
		        super.onDestroy();
//			        if(D) Log.e(TAG, "--- ON DESTROY ---");
		    }


}
