#
# program to plot a scan of admittance vs frequency
# as printed by the zmeter 's' command
#
# Jim Koehler, Comox, December 2017
#
#
# amended May, 2019 to set limits to the xrange as passed arguments
# and to plot logarithmic in x if the third argument is less than 0.5
#
set terminal push
set terminal png
set output "scan.png"
set logscale y
if (ARG3 < 0.5) {set logscale x}
else  {unset logscale x}
set grid mxtics mytics xtics ytics
#set grid
#unset xrange
set xrange [(ARG1/1000000):(ARG2/1000000)]
set title "Admittance vs Frequency"
set ylabel "Siemens"
set xlabel "Frequency in MHz"
plot "admittance.txt" u ($1/1000000):2 w points t "G" lt rgb "black", "" u ($1/1000000):3 w points t "Capacitive" lt rgb "red",  "" u ($1/1000000):(0 - $3) w points t "Inductive" lt rgb "green"
set terminal pop

