#
# program to plot a scan VSWR and return loss
#
# Jim Koehler, Comox, May, 2019
#
# amended April, 2019 to set limits to the xrange as passed arguments
# and to automatically switch from linear to logarithmic if the third argument is less than 1

set terminal push
set terminal png
set output "gamma.png"
if (ARG3 < 0.5) {set logscale x}
else  {unset logscale x}
set grid mxtics mytics xtics ytics
set ytics nomirror
set xrange [(ARG1/1000000):(ARG2/1000000)]
set title "Match vs Frequency"
set ylabel "VSWR"
set y2label "dB"
unset yrange
set y2range [-40.0:0.0]
set y2tics 10.0
set xlabel "Frequency in MHz"
plot "gamma.txt" u ($1/1000000):4 w points t "VSWR" lt rgb "black" axis x1y1, "" u ($1/1000000):5 w points t "Return Loss" lt rgb "red" axis x1y2
set terminal pop

