#!/usr/bin/python3
#
#
"""
     This program does a scan of the transmission
     over a range specified by the call

     The call is:

     ./trans_scan.py filename


        Jim Koehler, Comox, April, 2019
"""
import numpy as np
import math
import sys
import serial
import time
import os

def rect_to_polar(x, y):
    mag = math.sqrt(x**2 + y**2)
    ph = math.tan(y/x)
    return mag, ph

def polar_to_rect(mag, ph):
    x = mag * math.cos(ph)
    y = mag * math.sin(ph)
    return x, y

def get_cal():
    r = np.loadtxt("temp_cal.txt")
    return r


def do_scan():
    r = [0, 0]
    comm = serial.Serial('/dev/ttyACM0', baudrate = 115200, timeout = 0.3)
    comm.readlines()    # flush the read buffer
    comm.write(s2b("p\r")) # make the device print some lines
    time.sleep(0.2)
    comm.readlines()


    c = get_cal()   # the calibration array
    
    b = c[0,0]  # first frequency
    u = c[np.size(c,0) - 1, 0] # last frequency

    fh_out = open("trans.txt", "wb")
    fh_out.write(s2b("#    Transmission vs frequency\n"))
    fh_out.write(s2b("# \n"))
    fh_out.write(s2b("# freq         Mag (dB)           Phase (rad.)\n"))
    fh_out.write(s2b("# \n"))


    for i in range(np.size(c, 0)):
        f = c[i, 0]
        comm.write(s2b("f" + str(c[i,0]) + "\r"))   # set the frequency
        d =[]
        comm.write(s2b("m\r"))
        d = str.split(b2s(comm.readline())) # the seven list elements are all strings
        ratio = float(d[5]) / float(d[1])
        phase = float(d[2]) - float(d[6])
        ratio /= c[i, 1]
        phase -= c[i, 2]
        if (phase > 3.14159265):
            phase = phase - 6.2818531
        if (phase < -3.14159265):
            phase = phase + 6.2818531
        fh_out.write(s2b(str(f) + ' ' + str(20.0 * math.log10(ratio)) + ' ' + str(phase) + "\n"))
    return b, u

    fh_out.close()


def b2s(message):
    '''Byte to string'''
    return bytes.decode(message)

def s2b(message):
    '''string to bytes'''
    return bytearray(message, "ascii")

def main():
    filename = sys.argv[1]
    b, u = do_scan()
    string = "-c transplot.gp " + str(b) + " " + str(u)
    os.system("gnuplot " + string)
    os.system("feh scan.png")
    os.system("mv scan.png " + filename + ".png")
    os.system("mv trans.txt " + filename + ".txt")

if __name__=="__main__":
    main()
